/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.TableOutputCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableOutputFormat<KEY>
extends OutputFormat<KEY, Mutation>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(TableOutputFormat.class);
    public static final String OUTPUT_TABLE = "hbase.mapred.outputtable";
    public static final String OUTPUT_CONF_PREFIX = "hbase.mapred.output.";
    public static final String QUORUM_ADDRESS = "hbase.mapred.output.quorum";
    public static final String QUORUM_PORT = "hbase.mapred.output.quorum.port";
    public static final String REGION_SERVER_CLASS = "hbase.mapred.output.rs.class";
    public static final String REGION_SERVER_IMPL = "hbase.mapred.output.rs.impl";
    private Configuration conf = null;

    public RecordWriter<KEY, Mutation> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableRecordWriter();
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
             Admin admin = conn.getAdmin();){
            TableName tableName = TableName.valueOf((String)this.conf.get(OUTPUT_TABLE));
            if (!admin.tableExists(tableName)) {
                throw new TableNotFoundException("Can't write, table does not exist:" + tableName.getNameAsString());
            }
            if (!admin.isTableEnabled(tableName)) {
                throw new TableNotEnabledException("Can't write, table is not enabled: " + tableName.getNameAsString());
            }
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration otherConf) {
        String tableName = otherConf.get(OUTPUT_TABLE);
        if (tableName == null || tableName.length() <= 0) {
            throw new IllegalArgumentException("Must specify table name");
        }
        String address = otherConf.get(QUORUM_ADDRESS);
        int zkClientPort = otherConf.getInt(QUORUM_PORT, 0);
        String serverClass = otherConf.get(REGION_SERVER_CLASS);
        String serverImpl = otherConf.get(REGION_SERVER_IMPL);
        try {
            this.conf = HBaseConfiguration.createClusterConf((Configuration)otherConf, (String)address, (String)OUTPUT_CONF_PREFIX);
            if (serverClass != null) {
                this.conf.set("hbase.regionserver.impl", serverImpl);
            }
            if (zkClientPort != 0) {
                this.conf.setInt("hbase.zookeeper.property.clientPort", zkClientPort);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected class TableRecordWriter
    extends RecordWriter<KEY, Mutation> {
        private Connection connection;
        private BufferedMutator mutator;

        public TableRecordWriter() throws IOException {
            String tableName = TableOutputFormat.this.conf.get(TableOutputFormat.OUTPUT_TABLE);
            this.connection = ConnectionFactory.createConnection((Configuration)TableOutputFormat.this.conf);
            this.mutator = this.connection.getBufferedMutator(TableName.valueOf((String)tableName));
            LOG.info((Object)("Created table instance for " + tableName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(TaskAttemptContext context) throws IOException {
            try {
                if (this.mutator != null) {
                    this.mutator.close();
                }
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        public void write(KEY key, Mutation value) throws IOException {
            if (!(value instanceof Put) && !(value instanceof Delete)) {
                throw new IOException("Pass a Delete or a Put");
            }
            this.mutator.mutate(value);
        }
    }
}

