/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;

@InterfaceAudience.Private
public class MetricsCoprocessor {
    private static final String MASTER_COPROC_METRICS_NAME = "Coprocessor.Master";
    private static final String MASTER_COPROC_METRICS_CONTEXT = "master";
    private static final String MASTER_COPROC_METRICS_DESCRIPTION = "Metrics about HBase MasterObservers";
    private static final String MASTER_COPROC_METRICS_JMX_CONTEXT = "Master,sub=Coprocessor.Master";
    private static final String RS_COPROC_METRICS_NAME = "Coprocessor.RegionServer";
    private static final String RS_COPROC_METRICS_CONTEXT = "regionserver";
    private static final String RS_COPROC_METRICS_DESCRIPTION = "Metrics about HBase RegionServerObservers";
    private static final String RS_COPROC_METRICS_JMX_CONTEXT = "RegionServer,sub=Coprocessor.RegionServer";
    private static final String REGION_COPROC_METRICS_NAME = "Coprocessor.Region";
    private static final String REGION_COPROC_METRICS_CONTEXT = "regionserver";
    private static final String REGION_COPROC_METRICS_DESCRIPTION = "Metrics about HBase RegionObservers";
    private static final String REGION_COPROC_METRICS_JMX_CONTEXT = "RegionServer,sub=Coprocessor.Region";
    private static final String WAL_COPROC_METRICS_NAME = "Coprocessor.WAL";
    private static final String WAL_COPROC_METRICS_CONTEXT = "regionserver";
    private static final String WAL_COPROC_METRICS_DESCRIPTION = "Metrics about HBase WALObservers";
    private static final String WAL_COPROC_METRICS_JMX_CONTEXT = "RegionServer,sub=Coprocessor.WAL";

    private static String suffix(String metricName, String cpName) {
        return metricName + "." + "CP_" + cpName;
    }

    static MetricRegistryInfo createRegistryInfoForMasterCoprocessor(String clazz) {
        return new MetricRegistryInfo(MetricsCoprocessor.suffix(MASTER_COPROC_METRICS_NAME, clazz), MASTER_COPROC_METRICS_DESCRIPTION, MetricsCoprocessor.suffix(MASTER_COPROC_METRICS_JMX_CONTEXT, clazz), MASTER_COPROC_METRICS_CONTEXT, false);
    }

    public static MetricRegistry createRegistryForMasterCoprocessor(String clazz) {
        return MetricRegistries.global().create(MetricsCoprocessor.createRegistryInfoForMasterCoprocessor(clazz));
    }

    static MetricRegistryInfo createRegistryInfoForRSCoprocessor(String clazz) {
        return new MetricRegistryInfo(MetricsCoprocessor.suffix(RS_COPROC_METRICS_NAME, clazz), RS_COPROC_METRICS_DESCRIPTION, MetricsCoprocessor.suffix(RS_COPROC_METRICS_JMX_CONTEXT, clazz), "regionserver", false);
    }

    public static MetricRegistry createRegistryForRSCoprocessor(String clazz) {
        return MetricRegistries.global().create(MetricsCoprocessor.createRegistryInfoForRSCoprocessor(clazz));
    }

    public static MetricRegistryInfo createRegistryInfoForRegionCoprocessor(String clazz) {
        return new MetricRegistryInfo(MetricsCoprocessor.suffix(REGION_COPROC_METRICS_NAME, clazz), REGION_COPROC_METRICS_DESCRIPTION, MetricsCoprocessor.suffix(REGION_COPROC_METRICS_JMX_CONTEXT, clazz), "regionserver", false);
    }

    public static MetricRegistry createRegistryForRegionCoprocessor(String clazz) {
        return MetricRegistries.global().create(MetricsCoprocessor.createRegistryInfoForRegionCoprocessor(clazz));
    }

    public static MetricRegistryInfo createRegistryInfoForWALCoprocessor(String clazz) {
        return new MetricRegistryInfo(MetricsCoprocessor.suffix(WAL_COPROC_METRICS_NAME, clazz), WAL_COPROC_METRICS_DESCRIPTION, MetricsCoprocessor.suffix(WAL_COPROC_METRICS_JMX_CONTEXT, clazz), "regionserver", false);
    }

    public static MetricRegistry createRegistryForWALCoprocessor(String clazz) {
        return MetricRegistries.global().create(MetricsCoprocessor.createRegistryInfoForWALCoprocessor(clazz));
    }

    public static void removeRegistry(MetricRegistry registry) {
        if (registry == null) {
            return;
        }
        MetricRegistries.global().remove(registry.getMetricRegistryInfo());
    }
}

