/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestCompactionInDeadRegionServer {
    private static final Log LOG = LogFactory.getLog(TestCompactionInDeadRegionServer.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");

    @Before
    public void setUp() throws Exception {
        int i;
        UTIL.getConfiguration().setInt("zookeeper.session.timeout", 2000);
        UTIL.getConfiguration().setClass("hbase.regionserver.impl", IgnoreYouAreDeadRS.class, HRegionServer.class);
        UTIL.startMiniCluster(2);
        HTable table = UTIL.createTable(TABLE_NAME, CF);
        for (i = 0; i < 10; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
        }
        UTIL.getHBaseAdmin().flush(TABLE_NAME);
        for (i = 10; i < 20; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
        }
        UTIL.getHBaseAdmin().flush(TABLE_NAME);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        HRegionServer regionSvr = UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        Region region = (Region)regionSvr.getOnlineRegions(TABLE_NAME).get(0);
        String regName = region.getRegionInfo().getEncodedName();
        List metaRegs = regionSvr.getOnlineRegions(TableName.META_TABLE_NAME);
        if (metaRegs != null && !metaRegs.isEmpty()) {
            LOG.info((Object)("meta is on the same server: " + regionSvr));
            HRegionServer otherRs = UTIL.getOtherRegionServer(regionSvr);
            UTIL.moveRegionAndWait(region.getRegionInfo(), otherRs.getServerName());
            LOG.info((Object)("Moved region: " + regName + " to " + otherRs.getServerName()));
        }
        final HRegionServer rsToSuspend = UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        region = (HRegion)rsToSuspend.getOnlineRegions(TABLE_NAME).get(0);
        ZooKeeperWatcher watcher = UTIL.getZooKeeperWatcher();
        watcher.getRecoverableZooKeeper().delete(ZKUtil.joinZNode((String)watcher.rsZNode, (String)rsToSuspend.getServerName().toString()), -1);
        UTIL.waitFor(60000L, 1000L, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (JVMClusterUtil.RegionServerThread thread : UTIL.getHBaseCluster().getRegionServerThreads()) {
                    HRegionServer rs = thread.getRegionServer();
                    if (rs == rsToSuspend) continue;
                    return !rs.getOnlineRegions(TABLE_NAME).isEmpty();
                }
                return false;
            }

            public String explainFailure() throws Exception {
                return "The region for " + TABLE_NAME + " is still on " + rsToSuspend.getServerName();
            }
        });
        try {
            ((HRegion)region).compact(true);
            Assert.fail((String)"Should fail as our wal file has already been closed, and walDir has also been renamed");
        }
        catch (Exception e) {
            LOG.debug((Object)"expected exception: ", (Throwable)e);
        }
        Table table = UTIL.getConnection().getTable(TABLE_NAME);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])table.get(new Get(Bytes.toBytes((int)i))).getValue(CF, CQ)));
        }
    }

    public static final class IgnoreYouAreDeadRS
    extends HRegionServer {
        public IgnoreYouAreDeadRS(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public IgnoreYouAreDeadRS(Configuration conf, CoordinatedStateManager csm) throws IOException, InterruptedException {
            super(conf, csm);
        }

        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) throws IOException {
            try {
                super.tryRegionServerReport(reportStartTime, reportEndTime);
            }
            catch (YouAreDeadException youAreDeadException) {
                // empty catch block
            }
        }
    }
}

