/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProtobufUtil {
    private static final String TAG_STR = "tag-1";
    private static final byte TAG_TYPE = 10;

    @Test
    public void testException() throws IOException {
        HBaseProtos.NameBytesPair.Builder builder = HBaseProtos.NameBytesPair.newBuilder();
        String omg = "OMG!!!";
        builder.setName("java.io.IOException");
        builder.setValue(ByteStringer.wrap((byte[])Bytes.toBytes((String)"OMG!!!")));
        Throwable t = ProtobufUtil.toException((HBaseProtos.NameBytesPair)builder.build());
        Assert.assertEquals((Object)"OMG!!!", (Object)t.getMessage());
        builder.clear();
        builder.setName("org.apache.hadoop.ipc.RemoteException");
        builder.setValue(ByteStringer.wrap((byte[])Bytes.toBytes((String)"OMG!!!")));
        t = ProtobufUtil.toException((HBaseProtos.NameBytesPair)builder.build());
        Assert.assertEquals((Object)"OMG!!!", (Object)t.getMessage());
    }

    @Test
    public void testGet() throws IOException {
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c2"));
        getBuilder.addColumn(columnBuilder.build());
        columnBuilder.clear();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f2"));
        getBuilder.addColumn(columnBuilder.build());
        getBuilder.setLoadColumnFamiliesOnDemand(true);
        ClientProtos.Get proto = getBuilder.build();
        Assert.assertEquals((long)1L, (long)proto.getMaxVersions());
        Assert.assertEquals((Object)true, (Object)proto.getCacheBlocks());
        getBuilder = ClientProtos.Get.newBuilder((ClientProtos.Get)proto);
        getBuilder.setMaxVersions(1);
        getBuilder.setCacheBlocks(true);
        Get get = ProtobufUtil.toGet((ClientProtos.Get)proto);
        Assert.assertEquals((Object)getBuilder.build(), (Object)ProtobufUtil.toGet((Get)get));
    }

    @Test
    public void testAppend() throws IOException {
        long timeStamp = 111111L;
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.APPEND);
        mutateBuilder.setTimestamp(timeStamp);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v1"));
        qualifierBuilder.setTimestamp(timeStamp);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v2"));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setTimestamp(timeStamp);
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)proto, null);
        mutateBuilder.setTimestamp(append.getTimeStamp());
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.APPEND, (Mutation)append));
    }

    @Test
    public void testDelete() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.DELETE);
        mutateBuilder.setTimestamp(111111L);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setDeleteType(ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION);
        qualifierBuilder.setTimestamp(111222L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setDeleteType(ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS);
        qualifierBuilder.setTimestamp(111333L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)proto);
        for (ClientProtos.MutationProto.ColumnValue.Builder column : mutateBuilder.getColumnValueBuilderList()) {
            for (ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifier : column.getQualifierValueBuilderList()) {
                qualifier.setValue(ByteString.EMPTY);
            }
        }
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)delete));
    }

    @Test
    public void testIncrement() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteStringer.wrap((byte[])Bytes.toBytes((long)11L)));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteStringer.wrap((byte[])Bytes.toBytes((long)22L)));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Increment increment = ProtobufUtil.toIncrement((ClientProtos.MutationProto)proto, null);
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((Increment)increment, (ClientProtos.MutationProto.Builder)ClientProtos.MutationProto.newBuilder(), (long)0L));
    }

    @Test
    public void testIncrementRequestConversion() throws Exception {
        Increment inc = new Increment(Bytes.toBytes((String)"row1"));
        inc.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), 10L);
        inc.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q2"), 20L);
        inc.addColumn(Bytes.toBytes((String)"f2"), Bytes.toBytes((String)"q3"), 30L);
        ClientProtos.MutationProto proto = ProtobufUtil.toMutation((Increment)inc, (ClientProtos.MutationProto.Builder)ClientProtos.MutationProto.newBuilder(), (long)0L);
        Increment deSerializedIncrement = ProtobufUtil.toIncrement((ClientProtos.MutationProto)proto, null);
        List cellList = (List)deSerializedIncrement.getFamilyCellMap().get(Bytes.toBytes((String)"f1"));
        Collections.sort(cellList, KeyValue.COMPARATOR);
        Cell cell0 = (Cell)((List)inc.getFamilyCellMap().get(Bytes.toBytes((String)"f1"))).get(0);
        Cell cell1 = (Cell)((List)inc.getFamilyCellMap().get(Bytes.toBytes((String)"f2"))).get(0);
        Assert.assertEquals((long)Bytes.compareTo((byte[])cell0.getRowArray(), (int)cell0.getRowOffset(), (int)cell0.getRowLength(), (byte[])((Cell)cellList.get(0)).getRowArray(), (int)((Cell)cellList.get(0)).getRowOffset(), (int)((Cell)cellList.get(0)).getRowLength()), (long)0L);
        Assert.assertEquals((long)Bytes.compareTo((byte[])cell0.getQualifierArray(), (int)cell0.getQualifierOffset(), (int)cell0.getQualifierLength(), (byte[])((Cell)cellList.get(0)).getQualifierArray(), (int)((Cell)cellList.get(0)).getQualifierOffset(), (int)((Cell)cellList.get(0)).getQualifierLength()), (long)0L);
        Assert.assertEquals((long)Bytes.compareTo((byte[])cell0.getValueArray(), (int)cell0.getValueOffset(), (int)cell0.getValueLength(), (byte[])((Cell)cellList.get(0)).getValueArray(), (int)((Cell)cellList.get(0)).getValueOffset(), (int)((Cell)cellList.get(0)).getValueLength()), (long)0L);
        Cell deSerCell = (Cell)((List)deSerializedIncrement.getFamilyCellMap().get(Bytes.toBytes((String)"f2"))).get(0);
        Assert.assertEquals((long)Bytes.compareTo((byte[])cell1.getRowArray(), (int)cell1.getRowOffset(), (int)cell1.getRowLength(), (byte[])deSerCell.getRowArray(), (int)deSerCell.getRowOffset(), (int)deSerCell.getRowLength()), (long)0L);
        Assert.assertEquals((long)Bytes.compareTo((byte[])cell1.getQualifierArray(), (int)cell1.getQualifierOffset(), (int)cell1.getQualifierLength(), (byte[])deSerCell.getQualifierArray(), (int)deSerCell.getQualifierOffset(), (int)deSerCell.getQualifierLength()), (long)0L);
        Assert.assertEquals((long)Bytes.compareTo((byte[])cell1.getValueArray(), (int)cell1.getValueOffset(), (int)cell1.getValueLength(), (byte[])deSerCell.getValueArray(), (int)deSerCell.getValueOffset(), (int)deSerCell.getValueLength()), (long)0L);
    }

    @Test
    public void testPut() throws IOException {
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFromUtf8((String)"row"));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.PUT);
        mutateBuilder.setTimestamp(111111L);
        ClientProtos.MutationProto.ColumnValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        valueBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifierBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c1"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v1"));
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        qualifierBuilder.setQualifier(ByteString.copyFromUtf8((String)"c2"));
        qualifierBuilder.setValue(ByteString.copyFromUtf8((String)"v2"));
        qualifierBuilder.setTimestamp(222222L);
        valueBuilder.addQualifierValue(qualifierBuilder.build());
        mutateBuilder.addColumnValue(valueBuilder.build());
        ClientProtos.MutationProto proto = mutateBuilder.build();
        Assert.assertEquals((Object)ClientProtos.MutationProto.Durability.USE_DEFAULT, (Object)proto.getDurability());
        mutateBuilder = ClientProtos.MutationProto.newBuilder((ClientProtos.MutationProto)proto);
        mutateBuilder.setDurability(ClientProtos.MutationProto.Durability.USE_DEFAULT);
        Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)proto);
        long timestamp = put.getTimeStamp();
        for (ClientProtos.MutationProto.ColumnValue.Builder column : mutateBuilder.getColumnValueBuilderList()) {
            for (ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder qualifier : column.getQualifierValueBuilderList()) {
                if (qualifier.hasTimestamp()) continue;
                qualifier.setTimestamp(timestamp);
            }
        }
        Assert.assertEquals((Object)mutateBuilder.build(), (Object)ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)put));
    }

    @Test
    public void testScan() throws IOException {
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setStartRow(ByteString.copyFromUtf8((String)"row1"));
        scanBuilder.setStopRow(ByteString.copyFromUtf8((String)"row2"));
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c1"));
        columnBuilder.addQualifier(ByteString.copyFromUtf8((String)"c2"));
        scanBuilder.addColumn(columnBuilder.build());
        columnBuilder.clear();
        columnBuilder.setFamily(ByteString.copyFromUtf8((String)"f2"));
        scanBuilder.addColumn(columnBuilder.build());
        ClientProtos.Scan proto = scanBuilder.build();
        Assert.assertEquals((long)1L, (long)proto.getMaxVersions());
        Assert.assertEquals((Object)true, (Object)proto.getCacheBlocks());
        scanBuilder = ClientProtos.Scan.newBuilder((ClientProtos.Scan)proto);
        scanBuilder.setMaxVersions(2);
        scanBuilder.setCacheBlocks(false);
        scanBuilder.setCaching(1024);
        scanBuilder.setIncludeStopRow(false);
        ClientProtos.Scan expectedProto = scanBuilder.build();
        ClientProtos.Scan actualProto = ProtobufUtil.toScan((Scan)ProtobufUtil.toScan((ClientProtos.Scan)expectedProto));
        Assert.assertEquals((Object)expectedProto, (Object)actualProto);
    }

    @Test
    public void testMetaRegionState() throws Exception {
        ServerName serverName = ServerName.valueOf((String)"localhost", (int)1234, (long)5678L);
        for (RegionState.State state : RegionState.State.values()) {
            RegionState regionState = new RegionState(HRegionInfo.FIRST_META_REGIONINFO, state, serverName);
            ZooKeeperProtos.MetaRegionServer metars = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)serverName)).setRpcVersion(0).setState(state.convert()).build();
            byte[] data = ProtobufUtil.prependPBMagic((byte[])metars.toByteArray());
            ProtobufUtil.prependPBMagic((byte[])data);
            RegionState regionStateNew = ProtobufUtil.parseMetaRegionStateFrom((byte[])data, (int)1);
            Assert.assertEquals((Object)regionState.getServerName(), (Object)regionStateNew.getServerName());
            Assert.assertEquals((Object)regionState.getState(), (Object)regionStateNew.getState());
        }
        RegionState rs = ProtobufUtil.parseMetaRegionStateFrom((byte[])serverName.getVersionedBytes(), (int)1);
        Assert.assertEquals((Object)serverName, (Object)rs.getServerName());
        Assert.assertEquals((Object)rs.getState(), (Object)RegionState.State.OPEN);
    }

    @Test
    public void testCellConversionWithTags() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)true);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, true);
        List decodedTags = Tag.asList((byte[])decodedCell.getTagsArray(), (int)decodedCell.getTagsOffset(), (int)decodedCell.getTagsLength());
        Assert.assertEquals((long)1L, (long)decodedTags.size());
        Tag decodedTag = (Tag)decodedTags.get(0);
        Assert.assertEquals((long)10L, (long)decodedTag.getType());
        Assert.assertEquals((Object)TAG_STR, (Object)Bytes.toStringBinary((byte[])decodedTag.getValue()));
    }

    private Cell getCellWithTags() {
        Tag tag = new Tag(10, TAG_STR);
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"q1"), 10L, Bytes.toBytes((String)"value1"), new Tag[]{tag});
        return kv;
    }

    private Cell getCellFromProtoResult(CellProtos.Cell protoCell, boolean decodeTags) {
        return ProtobufUtil.toCell((CellProtos.Cell)protoCell, (boolean)decodeTags);
    }

    @Test
    public void testCellConversionWithoutTags() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)false);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, false);
        List decodedTags = Tag.asList((byte[])decodedCell.getTagsArray(), (int)decodedCell.getTagsOffset(), (int)decodedCell.getTagsLength());
        Assert.assertEquals((long)0L, (long)decodedTags.size());
    }

    @Test
    public void testTagEncodeFalseDecodeTrue() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)false);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, true);
        List decodedTags = Tag.asList((byte[])decodedCell.getTagsArray(), (int)decodedCell.getTagsOffset(), (int)decodedCell.getTagsLength());
        Assert.assertEquals((long)0L, (long)decodedTags.size());
    }

    @Test
    public void testTagEncodeTrueDecodeFalse() {
        Cell cell = this.getCellWithTags();
        CellProtos.Cell protoCell = ProtobufUtil.toCell((Cell)cell, (boolean)true);
        Assert.assertNotNull((Object)protoCell);
        Cell decodedCell = this.getCellFromProtoResult(protoCell, false);
        List decodedTags = Tag.asList((byte[])decodedCell.getTagsArray(), (int)decodedCell.getTagsOffset(), (int)decodedCell.getTagsLength());
        Assert.assertEquals((long)0L, (long)decodedTags.size());
    }
}

