/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTaskMonitor {
    @Test
    public void testTaskMonitorBasics() {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        MonitoredTask task = tm.createStatus("Test task");
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)task.getDescription(), (Object)taskFromTm.getDescription());
        Assert.assertEquals((long)-1L, (long)taskFromTm.getCompletionTimestamp());
        Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)taskFromTm.getState());
        task.markComplete("Finished!");
        Assert.assertEquals((Object)MonitoredTask.State.COMPLETE, (Object)task.getState());
        Assert.assertEquals((long)1L, (long)tm.getTasks().size());
        task.expireNow();
        Assert.assertEquals((long)0L, (long)tm.getTasks().size());
        tm.shutdown();
    }

    @Test
    public void testTasksGetAbortedOnLeak() throws InterruptedException {
        final TaskMonitor tm = new TaskMonitor(new Configuration());
        Assert.assertTrue((String)"Task monitor should start empty", (boolean)tm.getTasks().isEmpty());
        final AtomicBoolean threadSuccess = new AtomicBoolean(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                MonitoredTask task = tm.createStatus("Test task");
                Assert.assertEquals((Object)MonitoredTask.State.RUNNING, (Object)task.getState());
                threadSuccess.set(true);
            }
        };
        t.start();
        t.join();
        Assert.assertTrue((boolean)threadSuccess.get());
        System.gc();
        System.gc();
        System.gc();
        MonitoredTask taskFromTm = (MonitoredTask)tm.getTasks().get(0);
        Assert.assertEquals((Object)MonitoredTask.State.ABORTED, (Object)taskFromTm.getState());
        tm.shutdown();
    }

    @Test
    public void testTaskLimit() throws Exception {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        for (int i = 0; i < 1010; ++i) {
            tm.createStatus("task " + i);
        }
        Assert.assertEquals((long)1000L, (long)tm.getTasks().size());
        Assert.assertEquals((Object)"task 10", (Object)((MonitoredTask)tm.getTasks().get(0)).getDescription());
        tm.shutdown();
    }

    @Test
    public void testDoNotPurgeRPCTask() throws Exception {
        int i;
        int RPCTaskNums = 10;
        TaskMonitor tm = TaskMonitor.get();
        for (i = 0; i < RPCTaskNums; ++i) {
            tm.createRPCStatus("PRCTask" + i);
        }
        for (i = 0; i < 1000; ++i) {
            tm.createStatus("otherTask" + i);
        }
        int remainRPCTask = 0;
        for (MonitoredTask task : tm.getTasks()) {
            if (!(task instanceof MonitoredRPCHandler)) continue;
            ++remainRPCTask;
        }
        Assert.assertEquals((String)"RPC Tasks have been purged!", (long)RPCTaskNums, (long)remainRPCTask);
        tm.shutdown();
    }

    @Test
    public void testWarnStuckTasks() throws Exception {
        int RPC_WARN_TIME = 1500;
        int MONITOR_INTERVAL = 500;
        Configuration conf = new Configuration();
        conf.setLong("hbase.taskmonitor.rpc.warn.time", 1500L);
        conf.setLong("hbase.taskmonitor.monitor.interval", 500L);
        TaskMonitor tm = new TaskMonitor(conf);
        MonitoredRPCHandler t = tm.createRPCStatus("test task");
        long beforeSetRPC = EnvironmentEdgeManager.currentTime();
        Assert.assertTrue((String)"Validating initialization assumption", (t.getWarnTime() <= beforeSetRPC ? 1 : 0) != 0);
        Thread.sleep(1000L);
        t.setRPC("testMethod", new Object[0], beforeSetRPC);
        long afterSetRPC = EnvironmentEdgeManager.currentTime();
        Thread.sleep(1000L);
        Assert.assertTrue((String)"Validating no warn after starting RPC", (t.getWarnTime() <= afterSetRPC ? 1 : 0) != 0);
        Thread.sleep(1000L);
        Assert.assertTrue((String)"Validating warn after RPC_WARN_TIME", (t.getWarnTime() > afterSetRPC ? 1 : 0) != 0);
        tm.shutdown();
    }

    @Test
    public void testStatusJournal() {
        TaskMonitor tm = new TaskMonitor(new Configuration());
        MonitoredTask task = tm.createStatus("Test task");
        Assert.assertTrue((boolean)task.getStatusJournal().isEmpty());
        task.disableStatusJournal();
        task.setStatus("status1");
        Assert.assertTrue((boolean)task.getStatusJournal().isEmpty());
        task.enableStatusJournal(true);
        Assert.assertEquals((Object)"status1", (Object)((MonitoredTask.StatusJournalEntry)task.getStatusJournal().get(0)).getStatus());
        Assert.assertTrue((((MonitoredTask.StatusJournalEntry)task.getStatusJournal().get(0)).getTimeStamp() > 0L ? 1 : 0) != 0);
        task.disableStatusJournal();
        task.setStatus("status2");
        Assert.assertEquals((long)1L, (long)task.getStatusJournal().size());
        task.enableStatusJournal(false);
        Assert.assertEquals((long)1L, (long)task.getStatusJournal().size());
        task.setStatus("status3");
        Assert.assertEquals((Object)"status3", (Object)((MonitoredTask.StatusJournalEntry)task.getStatusJournal().get(1)).getStatus());
        tm.shutdown();
    }
}

