/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestBalancerDecision
extends BalancerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBalancerDecisions() {
        conf.setBoolean("hbase.master.balancer.decision.buffer.enabled", true);
        loadBalancer.setConf(conf);
        float minCost = conf.getFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 0.05f);
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        try {
            boolean[] perTableBalancerConfigs;
            for (boolean isByTable : perTableBalancerConfigs = new boolean[]{true, false}) {
                conf.setBoolean("hbase.master.loadbalance.bytable", isByTable);
                loadBalancer.setConf(conf);
                for (int[] mockCluster : this.clusterStateMocks) {
                    TreeMap<ServerName, List<HRegionInfo>> servers = this.mockClusterServers(mockCluster);
                    List plans = loadBalancer.balanceCluster(servers);
                    boolean emptyPlans = plans == null || plans.isEmpty();
                    Assert.assertTrue((emptyPlans || this.needsBalanceIdleRegion(mockCluster) ? 1 : 0) != 0);
                }
            }
            NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
            namedQueueGetRequest.setNamedQueueEvent(1);
            namedQueueGetRequest.setBalancerDecisionsRequest(MasterProtos.BalancerDecisionsRequest.getDefaultInstance());
            NamedQueueGetResponse namedQueueGetResponse = TestBalancerDecision.loadBalancer.namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
            List balancerDecisions = namedQueueGetResponse.getBalancerDecisions();
            MasterProtos.BalancerDecisionsResponse response = MasterProtos.BalancerDecisionsResponse.newBuilder().addAllBalancerDecision((Iterable)balancerDecisions).build();
            List balancerDecisionRecords = ProtobufUtil.getBalancerDecisionEntries((MasterProtos.BalancerDecisionsResponse)response);
            Assert.assertTrue((balancerDecisionRecords.size() > 160 ? 1 : 0) != 0);
        }
        finally {
            conf.unset("hbase.master.loadbalance.bytable");
            conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", minCost);
            loadBalancer.setConf(conf);
        }
    }

    private boolean needsBalanceIdleRegion(int[] clusters) {
        boolean b1 = false;
        boolean b2 = false;
        for (int cluster : clusters) {
            if (cluster > 1) {
                b1 = true;
                continue;
            }
            b2 = true;
        }
        return b1 && b2;
    }
}

