/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.lang.reflect.Field;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.balancer.BalancerChore;
import org.apache.hadoop.hbase.master.balancer.ClusterStatusChore;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterChoreScheduled {
    private static HMaster hMaster;
    private static final HBaseTestingUtility UTIL;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1, 1);
        hMaster = UTIL.getMiniHBaseCluster().getMaster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDefaultScheduledChores() throws Exception {
        TestChoreField logCleanerTestChoreField = new TestChoreField();
        LogCleaner logCleaner = (LogCleaner)logCleanerTestChoreField.getChoreObj("logCleaner");
        logCleanerTestChoreField.testIfChoreScheduled((ScheduledChore)logCleaner);
        TestChoreField hFileCleanerTestChoreField = new TestChoreField();
        HFileCleaner hFileCleaner = (HFileCleaner)hFileCleanerTestChoreField.getChoreObj("hfileCleaner");
        hFileCleanerTestChoreField.testIfChoreScheduled((ScheduledChore)hFileCleaner);
        TestChoreField clusterStatusChoreTestChoreField = new TestChoreField();
        ClusterStatusChore clusterStatusChore = (ClusterStatusChore)clusterStatusChoreTestChoreField.getChoreObj("clusterStatusChore");
        clusterStatusChoreTestChoreField.testIfChoreScheduled((ScheduledChore)clusterStatusChore);
        TestChoreField balancerChoreTestChoreField = new TestChoreField();
        BalancerChore balancerChore = (BalancerChore)balancerChoreTestChoreField.getChoreObj("balancerChore");
        balancerChoreTestChoreField.testIfChoreScheduled((ScheduledChore)balancerChore);
        TestChoreField regionNormalizerChoreTestChoreField = new TestChoreField();
        RegionNormalizerChore regionNormalizerChore = (RegionNormalizerChore)regionNormalizerChoreTestChoreField.getChoreObj("normalizerChore");
        regionNormalizerChoreTestChoreField.testIfChoreScheduled((ScheduledChore)regionNormalizerChore);
        TestChoreField catalogJanitorTestChoreField = new TestChoreField();
        CatalogJanitor catalogJanitor = (CatalogJanitor)catalogJanitorTestChoreField.getChoreObj("catalogJanitorChore");
        catalogJanitorTestChoreField.testIfChoreScheduled((ScheduledChore)catalogJanitor);
    }

    static {
        UTIL = new HBaseTestingUtility();
    }

    private static class TestChoreField<E extends ScheduledChore> {
        private TestChoreField() {
        }

        private E getChoreObj(String fieldName) throws NoSuchFieldException, IllegalAccessException {
            Field masterField = HMaster.class.getDeclaredField(fieldName);
            masterField.setAccessible(true);
            ScheduledChore choreFieldVal = (ScheduledChore)masterField.get(hMaster);
            return (E)choreFieldVal;
        }

        private void testIfChoreScheduled(E choreObj) {
            Assert.assertNotNull(choreObj);
            Assert.assertTrue((boolean)hMaster.getChoreService().isChoreScheduled(choreObj));
        }
    }
}

