/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.LockTimeoutException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.quotas.ThrottlingException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMetaCache {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test_table");
    private static final byte[] FAMILY = Bytes.toBytes((String)"fam1");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private static HRegionServer badRS;
    private static final Logger LOG;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.regionserver.impl", new String[]{RegionServerWithFakeRpcServices.class.getName()});
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        badRS = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        Assert.assertTrue((boolean)(badRS.getRSRpcServices() instanceof FakeRSRpcServices));
        HTableDescriptor table = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        fam.setMaxVersions(2);
        table.addFamily(fam);
        TEST_UTIL.createTable(table, (byte[][])null);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveMetaCacheOnException() throws Exception {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new RoundRobinExceptionInjector());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.client.retries.number", "1");
        try (ConnectionManager.HConnectionImplementation conn = (ConnectionManager.HConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);){
            HTableInterface table = conn.getTable(TABLE_NAME);
            byte[] row = Bytes.toBytes((String)"row1");
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
            Get get = new Get(row);
            Append append = new Append(row);
            append.add(FAMILY, QUALIFIER, Bytes.toBytes((int)11));
            Increment increment = new Increment(row);
            increment.addColumn(FAMILY, QUALIFIER, 10L);
            Delete delete = new Delete(row);
            delete.addColumn(FAMILY, QUALIFIER);
            RowMutations mutations = new RowMutations(row);
            mutations.add(put);
            mutations.add(delete);
            for (int i = 0; i < 50; ++i) {
                boolean success;
                IOException exp;
                block7: {
                    exp = null;
                    success = false;
                    try {
                        table.put(put);
                        success = true;
                        table.get(get);
                        table.append(append);
                        table.increment(increment);
                        table.delete(delete);
                        table.mutateRow(mutations);
                    }
                    catch (IOException ex) {
                        if (!ClientExceptionsUtil.isMetaClearingException((Throwable)ex) && !success) break block7;
                        exp = ex;
                    }
                }
                if (exp != null && ClientExceptionsUtil.isMetaClearingException((Throwable)exp)) {
                    Assert.assertNull((Object)conn.getCachedLocation(TABLE_NAME, row));
                    continue;
                }
                if (!success) continue;
                Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, row));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheClearingOnCallQueueTooBig() throws Exception {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new CallQueueTooBigExceptionInjector());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.client.retries.number", "2");
        conf.set("hbase.client.metrics.enable", "true");
        try (ConnectionManager.HConnectionImplementation conn = (ConnectionManager.HConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);){
            HTableInterface table = conn.getTable(TABLE_NAME);
            byte[] row = Bytes.toBytes((String)"row1");
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
            table.put(put);
            MetricsConnection metrics = conn.getConnectionMetrics();
            long preGetRegionClears = metrics.metaCacheNumClearRegion.count();
            long preGetServerClears = metrics.metaCacheNumClearServer.count();
            Get get = new Get(row);
            try {
                table.get(get);
                Assert.fail((String)"Expected CallQueueTooBigException");
            }
            catch (RetriesExhaustedException retriesExhaustedException) {
                // empty catch block
            }
            long postGetRegionClears = metrics.metaCacheNumClearRegion.count();
            long postGetServerClears = metrics.metaCacheNumClearServer.count();
            junit.framework.Assert.assertEquals((long)preGetRegionClears, (long)postGetRegionClears);
            junit.framework.Assert.assertEquals((long)preGetServerClears, (long)postGetServerClears);
        }
    }

    public static List<Throwable> metaCachePreservingExceptions() {
        return new ArrayList<Throwable>(){
            {
                this.add(new RegionOpeningException(" "));
                this.add(new RegionTooBusyException());
                this.add(new ThrottlingException(" "));
                this.add(new MultiActionResultTooLarge(" "));
                this.add(new RetryImmediatelyException(" "));
                this.add(new CallQueueTooBigException());
            }
        };
    }

    @Test
    public void testUserRegionLockThrowsException() throws IOException, InterruptedException {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new LockSleepInjector());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.retries.number", 1);
        conf.setLong("hbase.client.meta.operation.timeout", 2000L);
        conf.setLong("hbase.client.scanner.timeout.period", 2000L);
        try (ConnectionManager.HConnectionImplementation conn = (ConnectionManager.HConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);){
            ClientThread client1 = new ClientThread(conn);
            ClientThread client2 = new ClientThread(conn);
            client1.start();
            client2.start();
            client1.join();
            client2.join();
            Assert.assertNotNull((Object)client1.getException());
            Assert.assertNotNull((Object)client2.getException());
            Assert.assertTrue((boolean)(client1.getException() instanceof LockTimeoutException ^ client2.getException() instanceof LockTimeoutException));
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TestMetaCache.class);
    }

    public static class LockSleepInjector
    extends ExceptionInjector {
        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted exception", (Throwable)e);
            }
        }

        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) {
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) {
        }
    }

    private final class ClientThread
    extends Thread {
        private Exception exception;
        private ConnectionManager.HConnectionImplementation connection;

        private ClientThread(ConnectionManager.HConnectionImplementation connection) {
            this.connection = connection;
        }

        @Override
        public void run() {
            byte[] currentKey = HConstants.EMPTY_START_ROW;
            try {
                this.connection.getRegionLocation(TABLE_NAME, currentKey, true);
            }
            catch (IOException e) {
                LOG.error("Thread id: " + this.getId() + "  exception: ", (Throwable)e);
                this.exception = e;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class CallQueueTooBigExceptionInjector
    extends ExceptionInjector {
        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) throws ServiceException {
            if (this.isTestTable(rpcServices, request.getRegion())) {
                throw new ServiceException((Throwable)new CallQueueTooBigException());
            }
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) throws ServiceException {
        }

        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) throws ServiceException {
        }
    }

    public static class RoundRobinExceptionInjector
    extends ExceptionInjector {
        private int numReqs = -1;
        private int expCount = -1;
        private List<Throwable> metaCachePreservingExceptions = TestMetaCache.metaCachePreservingExceptions();

        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) throws ServiceException {
            this.throwSomeExceptions(rpcServices, request.getRegion());
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) throws ServiceException {
            this.throwSomeExceptions(rpcServices, request.getRegion());
        }

        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) throws ServiceException {
            if (!request.hasScannerId()) {
                this.throwSomeExceptions(rpcServices, request.getRegion());
            }
        }

        private void throwSomeExceptions(FakeRSRpcServices rpcServices, HBaseProtos.RegionSpecifier regionSpec) throws ServiceException {
            if (!this.isTestTable(rpcServices, regionSpec)) {
                return;
            }
            ++this.numReqs;
            if (this.numReqs % 5 == 0) {
                return;
            }
            if (this.numReqs % 5 == 1 || this.numReqs % 5 == 2) {
                throw new ServiceException((Throwable)new NotServingRegionException());
            }
            ++this.expCount;
            Throwable t = this.metaCachePreservingExceptions.get(this.expCount % this.metaCachePreservingExceptions.size());
            throw new ServiceException(t);
        }
    }

    public static abstract class ExceptionInjector {
        protected boolean isTestTable(FakeRSRpcServices rpcServices, HBaseProtos.RegionSpecifier regionSpec) throws ServiceException {
            try {
                return TABLE_NAME.equals((Object)rpcServices.getRegion(regionSpec).getTableDesc().getTableName());
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }

        public abstract void throwOnGet(FakeRSRpcServices var1, ClientProtos.GetRequest var2) throws ServiceException;

        public abstract void throwOnMutate(FakeRSRpcServices var1, ClientProtos.MutateRequest var2) throws ServiceException;

        public abstract void throwOnScan(FakeRSRpcServices var1, ClientProtos.ScanRequest var2) throws ServiceException;
    }

    public static class FakeRSRpcServices
    extends RSRpcServices {
        private ExceptionInjector exceptions = new RoundRobinExceptionInjector();

        public FakeRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public void setExceptionInjector(ExceptionInjector injector) {
            this.exceptions = injector;
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            this.exceptions.throwOnGet(this, request);
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
            this.exceptions.throwOnMutate(this, request);
            return super.mutate(controller, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            this.exceptions.throwOnScan(this, request);
            return super.scan(controller, request);
        }

        public Region getRegion(HBaseProtos.RegionSpecifier regionSpecifier) throws IOException {
            return super.getRegion(regionSpecifier);
        }
    }

    public static class RegionServerWithFakeRpcServices
    extends HRegionServer {
        private FakeRSRpcServices rsRpcServices;

        public RegionServerWithFakeRpcServices(Configuration conf, CoordinatedStateManager cp) throws IOException, InterruptedException {
            super(conf, cp);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            this.rsRpcServices = new FakeRSRpcServices(this);
            return this.rsRpcServices;
        }

        public void setExceptionInjector(ExceptionInjector injector) {
            this.rsRpcServices.setExceptionInjector(injector);
        }
    }
}

