/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.FlushLargeStoresPolicy;
import org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class FlushPolicyFactory {
    private static final Log LOG = LogFactory.getLog(FlushPolicyFactory.class);
    public static final String HBASE_FLUSH_POLICY_KEY = "hbase.regionserver.flush.policy";
    private static final Class<? extends FlushPolicy> DEFAULT_FLUSH_POLICY_CLASS = FlushLargeStoresPolicy.class;

    public static FlushPolicy create(HRegion region, Configuration conf) throws IOException {
        Class<? extends FlushPolicy> clazz = FlushPolicyFactory.getFlushPolicyClass(region.getTableDesc(), conf);
        FlushPolicy policy = (FlushPolicy)((Object)ReflectionUtils.newInstance(clazz, (Configuration)conf));
        policy.configureForRegion(region);
        return policy;
    }

    public static Class<? extends FlushPolicy> getFlushPolicyClass(HTableDescriptor htd, Configuration conf) throws IOException {
        String className = htd.getFlushPolicyClassName();
        if (className == null) {
            className = conf.get(HBASE_FLUSH_POLICY_KEY, DEFAULT_FLUSH_POLICY_CLASS.getName());
        }
        try {
            Class<FlushPolicy> clazz = Class.forName(className).asSubclass(FlushPolicy.class);
            return clazz;
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to load configured flush policy '" + className + "' for table '" + htd.getTableName() + "', load default flush policy " + DEFAULT_FLUSH_POLICY_CLASS.getName() + " instead"), (Throwable)e);
            return DEFAULT_FLUSH_POLICY_CLASS;
        }
    }
}

