/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LossyCounting {
    private static final Logger LOG = LoggerFactory.getLogger(LossyCounting.class);
    private long bucketSize;
    private long currentTerm;
    private double errorRate;
    private Map<String, Integer> data;
    private long totalDataCount;
    private String name;

    public LossyCounting(double errorRate, String name) {
        this.errorRate = errorRate;
        this.name = name;
        if (errorRate < 0.0 || errorRate > 1.0) {
            throw new IllegalArgumentException(" Lossy Counting error rate should be within range [0,1]");
        }
        this.bucketSize = (long)Math.ceil(1.0 / errorRate);
        this.currentTerm = 1L;
        this.totalDataCount = 0L;
        this.data = new ConcurrentHashMap<String, Integer>();
        this.calculateCurrentTerm();
    }

    public LossyCounting(String name) {
        this(HBaseConfiguration.create().getDouble("hbase.util.default.lossycounting.errorrate", 0.02), name);
    }

    public Set<String> addByOne(String key) {
        if (!this.data.containsKey(key)) {
            this.data.put(key, 0);
        }
        this.data.put(key, this.data.get(key) + 1);
        ++this.totalDataCount;
        this.calculateCurrentTerm();
        Set<String> dataToBeSwept = new HashSet<String>();
        if (this.totalDataCount % this.bucketSize == 0L) {
            dataToBeSwept = this.sweep();
        }
        return dataToBeSwept;
    }

    private Set<String> sweep() {
        HashSet<String> dataToBeSwept = new HashSet<String>();
        for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
            if (!((double)entry.getValue().intValue() + this.errorRate < (double)this.currentTerm)) continue;
            dataToBeSwept.add(entry.getKey());
        }
        for (String key : dataToBeSwept) {
            this.data.remove(key);
        }
        LOG.trace(String.format("%s swept %d elements.", this.name, dataToBeSwept.size()));
        return dataToBeSwept;
    }

    private void calculateCurrentTerm() {
        this.currentTerm = (int)Math.ceil(1.0 * (double)this.totalDataCount / (double)this.bucketSize);
    }

    public long getBucketSize() {
        return this.bucketSize;
    }

    public long getDataSize() {
        return this.data.size();
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }
}

