/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class HFileTestUtil {
    public static void createHFile(Configuration configuration, FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFileTestUtil.createHFile(configuration, fs, path, DataBlockEncoding.NONE, family, qualifier, startKey, endKey, numRows, false);
    }

    public static void createHFileWithDataBlockEncoding(Configuration configuration, FileSystem fs, Path path, DataBlockEncoding encoding, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFileTestUtil.createHFile(configuration, fs, path, encoding, family, qualifier, startKey, endKey, numRows, false);
    }

    public static void createHFileWithTags(Configuration configuration, FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFileTestUtil.createHFile(configuration, fs, path, DataBlockEncoding.NONE, family, qualifier, startKey, endKey, numRows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHFile(Configuration configuration, FileSystem fs, Path path, DataBlockEncoding encoding, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows, boolean withTag) throws IOException {
        HFileContext meta = new HFileContextBuilder().withIncludesTags(withTag).withDataBlockEncoding(encoding).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)configuration, (CacheConfig)new CacheConfig(configuration)).withPath(fs, path).withFileContext(meta).create();
        long now = System.currentTimeMillis();
        try {
            for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (int)(numRows - 2))) {
                KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                if (withTag) {
                    ArrayList<Tag> tags = new ArrayList<Tag>();
                    tags.add(new Tag(1, key));
                    kv = new KeyValue(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), (int)kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.Put, kv.getValueArray(), kv.getValueOffset(), kv.getValueLength(), tags);
                    byte[] ta = kv.getTagsArray();
                    int toff = kv.getTagsOffset();
                    int tlen = kv.getTagsLength();
                    Tag t = Tag.getTag((byte[])ta, (int)toff, (int)tlen, (byte)1);
                    if (t == null) {
                        throw new IllegalStateException("Tag didn't stick to KV " + kv.toString());
                    }
                }
                writer.append((Cell)kv);
            }
        }
        finally {
            writer.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
            writer.close();
        }
    }

    public static void verifyTags(Table table) throws IOException {
        ResultScanner s = table.getScanner(new Scan());
        for (Result r : s) {
            for (Cell c : r.listCells()) {
                int tlen;
                int toff;
                byte[] ta = c.getTagsArray();
                Tag t = Tag.getTag((byte[])ta, (int)(toff = c.getTagsOffset()), (int)(tlen = c.getTagsLength()), (byte)1);
                if (t == null) {
                    Assert.fail((String)(c.toString() + " has null tag"));
                    continue;
                }
                byte[] tval = t.getValue();
                Assert.assertArrayEquals((String)(c.toString() + " has tag" + Bytes.toString((byte[])tval)), (byte[])r.getRow(), (byte[])tval);
            }
        }
    }
}

