/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestRegionPlan {
    private final ServerName SRC = ServerName.valueOf((String)"source", (int)1234, (long)2345L);
    private final ServerName DEST = ServerName.valueOf((String)"dest", (int)1234, (long)2345L);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testCompareTo() {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)this.name.getMethodName()));
        RegionPlan a = new RegionPlan(hri, null, null);
        RegionPlan b = new RegionPlan(hri, null, null);
        Assert.assertEquals((long)0L, (long)a.compareTo(b));
        a = new RegionPlan(hri, this.SRC, null);
        b = new RegionPlan(hri, null, null);
        Assert.assertEquals((long)1L, (long)a.compareTo(b));
        a = new RegionPlan(hri, null, null);
        b = new RegionPlan(hri, this.SRC, null);
        Assert.assertEquals((long)-1L, (long)a.compareTo(b));
        a = new RegionPlan(hri, this.SRC, null);
        b = new RegionPlan(hri, this.SRC, null);
        Assert.assertEquals((long)0L, (long)a.compareTo(b));
        a = new RegionPlan(hri, this.SRC, null);
        b = new RegionPlan(hri, this.SRC, this.DEST);
        Assert.assertEquals((long)-1L, (long)a.compareTo(b));
        a = new RegionPlan(hri, this.SRC, this.DEST);
        b = new RegionPlan(hri, this.SRC, this.DEST);
        Assert.assertEquals((long)0L, (long)a.compareTo(b));
    }

    @Test
    public void testEqualsWithNulls() {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)this.name.getMethodName()));
        RegionPlan a = new RegionPlan(hri, null, null);
        RegionPlan b = new RegionPlan(hri, null, null);
        Assert.assertTrue((boolean)a.equals((Object)b));
        a = new RegionPlan(hri, this.SRC, null);
        b = new RegionPlan(hri, null, null);
        TestCase.assertFalse((boolean)a.equals((Object)b));
        a = new RegionPlan(hri, this.SRC, null);
        b = new RegionPlan(hri, this.SRC, null);
        Assert.assertTrue((boolean)a.equals((Object)b));
        a = new RegionPlan(hri, this.SRC, null);
        b = new RegionPlan(hri, this.SRC, this.DEST);
        TestCase.assertFalse((boolean)a.equals((Object)b));
    }

    @Test
    public void testEquals() {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)this.name.getMethodName()));
        RegionPlan plan = new RegionPlan(hri, this.SRC, this.DEST);
        Assert.assertEquals((long)plan.hashCode(), (long)new RegionPlan(hri, this.SRC, this.DEST).hashCode());
        Assert.assertEquals((Object)plan, (Object)new RegionPlan(hri, this.SRC, this.DEST));
        HRegionInfo other = new HRegionInfo(TableName.valueOf((String)(this.name.getMethodName() + "other")));
        Assert.assertNotEquals((long)plan.hashCode(), (long)new RegionPlan(other, this.SRC, this.DEST).hashCode());
        Assert.assertNotEquals((Object)plan, (Object)new RegionPlan(other, this.SRC, this.DEST));
    }
}

