/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateClientSideReader;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAdmin1 {
    private static final Log LOG = LogFactory.getLog(TestAdmin1.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : this.admin.listTables()) {
            TEST_UTIL.deleteTable(htd.getName());
        }
    }

    @Test(timeout=300000L)
    public void testSplitFlushCompactUnknownTable() throws InterruptedException {
        TableName unknowntable = TableName.valueOf((String)"fubar");
        IOException exception = null;
        try {
            this.admin.compact(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.flush(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.split(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDeleteEditUnknownColumnFamilyAndOrTable() throws IOException {
        TableName nonexistentTable = TableName.valueOf((String)"nonexistent");
        byte[] nonexistentColumn = Bytes.toBytes((String)"nonexistent");
        HColumnDescriptor nonexistentHcd = new HColumnDescriptor(nonexistentColumn);
        IOException exception = null;
        try {
            this.admin.addColumn(nonexistentTable, nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteColumn(nonexistentTable, nonexistentColumn);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.disableTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.enableTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.modifyColumn(nonexistentTable, nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            HTableDescriptor htd = new HTableDescriptor(nonexistentTable);
            htd.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
            this.admin.modifyTable(htd.getTableName(), htd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        TableName tableName = TableName.valueOf((String)("testDeleteEditUnknownColumnFamilyAndOrTable" + System.currentTimeMillis()));
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("cf"));
        this.admin.createTable(htd);
        try {
            exception = null;
            try {
                this.admin.deleteColumn(htd.getTableName(), nonexistentHcd.getName());
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertNotNull((Object)exception);
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
            exception = null;
            try {
                this.admin.modifyColumn(htd.getTableName(), nonexistentHcd);
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertNotNull((Object)exception);
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
        }
        finally {
            this.admin.disableTable(tableName);
            this.admin.deleteTable(tableName);
        }
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableTable() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableName table = TableName.valueOf((String)"testDisableAndEnableTable");
        HTable ht = TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht.get(get);
        this.admin.disableTable(ht.getName());
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getTableStateManager().isTableState(ht.getName(), new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.DISABLED}));
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht.get(get);
        }
        catch (TableNotEnabledException e) {
            ok = true;
        }
        ok = false;
        Scan scan = new Scan();
        try {
            ResultScanner scanner = ht.getScanner(scan);
            Result res = null;
            while ((res = scanner.next()) != null) {
            }
        }
        catch (TableNotEnabledException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(table);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getTableStateManager().isTableState(ht.getName(), new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED}));
        try {
            ht.get(get);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht.close();
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableTables() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableName table1 = TableName.valueOf((String)"testDisableAndEnableTable1");
        TableName table2 = TableName.valueOf((String)"testDisableAndEnableTable2");
        HTable ht1 = TEST_UTIL.createTable(table1, HConstants.CATALOG_FAMILY);
        HTable ht2 = TEST_UTIL.createTable(table2, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht1.put(put);
        ht2.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht1.get(get);
        ht2.get(get);
        this.admin.disableTables("testDisableAndEnableTable.*");
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht1.get(get);
            ht2.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTables("testDisableAndEnableTable.*");
        try {
            ht1.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        try {
            ht2.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht1.close();
        ht2.close();
    }

    @Test(timeout=300000L)
    public void testCreateTable() throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(TableName.valueOf((String)"testCreateTable"), HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getTableStateManager().isTableState(TableName.valueOf((String)"testCreateTable"), new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED}));
    }

    @Test(timeout=300000L)
    public void testTruncateTable() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)"testTruncateTable"), false);
    }

    @Test(timeout=300000L)
    public void testTruncateTablePreservingSplits() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)"testTruncateTablePreservingSplits"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTruncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        try (HTable table = TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY, (byte[][])splitKeys);){
            TEST_UTIL.loadNumericRows((Table)table, HConstants.CATALOG_FAMILY, 0, 10);
            Assert.assertEquals((long)10L, (long)TEST_UTIL.countRows((Table)table));
        }
        Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        this.admin.disableTable(tableName);
        this.admin.truncateTable(tableName, preserveSplits);
        table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        try {
            Assert.assertEquals((long)0L, (long)TEST_UTIL.countRows((Table)table));
        }
        finally {
            table.close();
        }
        if (preserveSplits) {
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        }
    }

    @Test(timeout=300000L)
    public void testGetTableDescriptor() throws IOException {
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HColumnDescriptor fam2 = new HColumnDescriptor("fam2");
        HColumnDescriptor fam3 = new HColumnDescriptor("fam3");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"myTestTable"));
        htd.addFamily(fam1);
        htd.addFamily(fam2);
        htd.addFamily(fam3);
        this.admin.createTable(htd);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), htd.getTableName());
        HTableDescriptor confirmedHtd = table.getTableDescriptor();
        Assert.assertEquals((long)htd.compareTo(confirmedHtd), (long)0L);
        table.close();
    }

    @Test(timeout=300000L)
    public void testCompactionTimestamps() throws Exception {
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        TableName tableName = TableName.valueOf((String)"testCompactionTimestampsTable");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(fam1);
        this.admin.createTable(htd);
        HTable table = (HTable)TEST_UTIL.getConnection().getTable(htd.getTableName());
        long ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"));
        table.put(p);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        byte[] regionName = ((HRegionLocation)table.getRegionLocator().getAllRegionLocations().get(0)).getRegionInfo().getRegionName();
        long ts1 = this.admin.getLastMajorCompactionTimestampForRegion(regionName);
        Assert.assertEquals((long)ts, (long)ts1);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.add(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"));
        table.put(p);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)ts1, (long)ts);
        TEST_UTIL.compact(tableName, true);
        table.put(p);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertTrue((ts > ts1 ? 1 : 0) != 0);
        ts1 = this.admin.getLastMajorCompactionTimestampForRegion(regionName);
        Assert.assertEquals((long)ts, (long)ts1);
        table.put(p);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)ts, (long)ts1);
        table.close();
    }

    @Test(timeout=300000L)
    public void testHColumnValidName() {
        try {
            new HColumnDescriptor("\\test\\abc");
        }
        catch (IllegalArgumentException iae) {
            boolean exceptionThrown = true;
            Assert.assertTrue((boolean)exceptionThrown);
        }
    }

    @Test(timeout=300000L)
    public void testOnlineChangeTableSchema() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"changeTableSchemaOnline");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        HTableDescriptor modifiedHtd = this.admin.getTableDescriptor(tableName);
        Assert.assertFalse((boolean)htd.equals((Object)modifiedHtd));
        Assert.assertTrue((boolean)copy.equals((Object)modifiedHtd));
        Assert.assertEquals((long)newFlushSize, (long)modifiedHtd.getMemStoreFlushSize());
        Assert.assertEquals((Object)"anyoldkey", (Object)modifiedHtd.getValue("anyoldkey"));
        int countOfFamilies = modifiedHtd.getFamilies().size();
        Assert.assertTrue((countOfFamilies > 0 ? 1 : 0) != 0);
        HColumnDescriptor hcd = (HColumnDescriptor)modifiedHtd.getFamilies().iterator().next();
        int maxversions = hcd.getMaxVersions();
        int newMaxVersions = maxversions + 1;
        hcd.setMaxVersions(newMaxVersions);
        byte[] hcdName = hcd.getName();
        expectedException = false;
        try {
            this.admin.modifyColumn(tableName, hcd);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        HColumnDescriptor modifiedHcd = modifiedHtd.getFamily(hcdName);
        Assert.assertEquals((long)newMaxVersions, (long)modifiedHcd.getMaxVersions());
        Assert.assertFalse((boolean)this.admin.isTableDisabled(tableName));
        String xtracolName = "xtracol";
        HColumnDescriptor xtracol = new HColumnDescriptor("xtracol");
        xtracol.setValue("xtracol", "xtracol");
        expectedException = false;
        try {
            this.admin.addColumn(tableName, xtracol);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)hcd.getValue("xtracol").equals("xtracol"));
        this.admin.deleteColumn(tableName, xtracol.getName());
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd == null ? 1 : 0) != 0);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
        this.admin.listTables();
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
    }

    @Test(timeout=300000L)
    public void testShouldFailOnlineSchemaUpdateIfOnlineSchemaIsNotEnabled() throws Exception {
        TableName tableName = TableName.valueOf((String)"changeTableSchemaOnlineFailure");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", false);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertTrue((String)"Online schema update should not happen.", (boolean)expectedException);
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
    }

    protected void verifyRoundRobinDistribution(HTable ht, int expectedRegions) throws IOException {
        int numRS = ht.getConnection().getCurrentNrHRS();
        NavigableMap regions = ht.getRegionLocations();
        HashMap server2Regions = new HashMap();
        for (Map.Entry entry : regions.entrySet()) {
            ServerName server = (ServerName)entry.getValue();
            ArrayList regs = (ArrayList)server2Regions.get(server);
            if (regs == null) {
                regs = new ArrayList();
                server2Regions.put(server, regs);
            }
            regs.add(entry.getKey());
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        for (List regionList : server2Regions.values()) {
            Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
        }
    }

    @Test(timeout=300000L)
    public void testCreateTableNumberOfRegions() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testCreateTableNumberOfRegions");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap regions = ht.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 1 region", (long)1L, (long)regions.size());
        ht.close();
        TableName TABLE_2 = TableName.valueOf((String)(tableName.getNameAsString() + "_2"));
        desc = new HTableDescriptor(TABLE_2);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])new byte[][]{{42}});
        HTable ht2 = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht2.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 2 region", (long)2L, (long)regions.size());
        ht2.close();
        TableName TABLE_3 = TableName.valueOf((String)(tableName.getNameAsString() + "_3"));
        desc = new HTableDescriptor(TABLE_3);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, "a".getBytes(), "z".getBytes(), 3);
        HTable ht3 = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht3.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 3 region", (long)3L, (long)regions.size());
        ht3.close();
        TableName TABLE_4 = TableName.valueOf((String)(tableName.getNameAsString() + "_4"));
        desc = new HTableDescriptor(TABLE_4);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        try {
            this.admin.createTable(desc, "a".getBytes(), "z".getBytes(), 2);
            Assert.fail((String)"Should not be able to create a table with only 2 regions using this API.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TableName TABLE_5 = TableName.valueOf((String)(tableName.getNameAsString() + "_5"));
        desc = new HTableDescriptor(TABLE_5);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, new byte[]{1}, new byte[]{127}, 16);
        HTable ht5 = new HTable(TEST_UTIL.getConfiguration(), TABLE_5);
        regions = ht5.getRegionLocations();
        Assert.assertEquals((String)"Table should have 16 region", (long)16L, (long)regions.size());
        ht5.close();
    }

    @Test(timeout=300000L)
    public void testCreateTableWithRegions() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testCreateTableWithRegions");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])splitKeys);
        boolean tableAvailable = this.admin.isTableAvailable(tableName, (byte[][])splitKeys);
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)tableAvailable);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap regions = ht.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        Iterator hris = regions.keySet().iterator();
        HRegionInfo hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht, expectedRegions);
        ht.close();
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        TableName TABLE_2 = TableName.valueOf((String)(tableName.getNameAsString() + "_2"));
        desc = new HTableDescriptor(TABLE_2);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht2 = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht2.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.keySet().iterator();
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht2, expectedRegions);
        ht2.close();
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        TableName TABLE_3 = TableName.valueOf((String)(tableName.getNameAsString() + "_3"));
        desc = new HTableDescriptor(TABLE_3);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht3 = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht3.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        this.verifyRoundRobinDistribution(ht3, expectedRegions);
        ht3.close();
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        TableName TABLE_4 = TableName.valueOf((String)(tableName.getNameAsString() + "_4"));
        desc = new HTableDescriptor(TABLE_4);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        HBaseAdmin ladmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        try {
            ladmin.createTable(desc, (byte[][])splitKeys);
            Assert.assertTrue((String)"Should not be able to create this table because of duplicate split keys", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ladmin.close();
    }

    @Test(timeout=300000L)
    public void testTableAvailableWithRandomSplitKeys() throws Exception {
        TableName tableName = TableName.valueOf((String)"testTableAvailableWithRandomSplitKeys");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("col"));
        byte[][] splitKeys = new byte[1][];
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}};
        this.admin.createTable(desc);
        boolean tableAvailable = this.admin.isTableAvailable(tableName, (byte[][])splitKeys);
        Assert.assertFalse((String)"Table should be created with 1 row in META", (boolean)tableAvailable);
    }

    @Test(timeout=300000L)
    public void testCreateTableWithOnlyEmptyStartRow() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithOnlyEmptyStartRow");
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithEmptyRowInTheSplitKeys");
        byte[][] splitKeys = new byte[][]{"region1".getBytes(), HConstants.EMPTY_BYTE_ARRAY, "region2".getBytes()};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            LOG.info((Object)"Expected ", (Throwable)e);
        }
    }

    @Test(timeout=120000L)
    public void testTableExist() throws IOException {
        TableName table = TableName.valueOf((String)"testTableExist");
        boolean exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test(timeout=400000L)
    public void testForceSplit() throws Exception {
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf")};
        int[] rowCounts = new int[]{6000};
        int numVersions = HColumnDescriptor.DEFAULT_VERSIONS;
        int blockSize = 256;
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        byte[] splitKey = Bytes.toBytes((int)3500);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize);
    }

    @Test(timeout=300000L)
    public void testEnableTableRetainAssignment() throws IOException {
        TableName tableName = TableName.valueOf((String)"testEnableTableAssignment");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])splitKeys);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap regions = ht.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        this.admin.disableTable(tableName);
        this.admin.enableTable(tableName);
        NavigableMap regions2 = ht.getRegionLocations();
        Assert.assertEquals((long)regions.size(), (long)regions2.size());
        for (Map.Entry entry : regions.entrySet()) {
            Assert.assertEquals(regions2.get(entry.getKey()), entry.getValue());
        }
    }

    @Test(timeout=800000L)
    public void testForceSplitMultiFamily() throws Exception {
        int numVersions = HColumnDescriptor.DEFAULT_VERSIONS;
        int blockSize = 256;
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2")};
        int[] rowCounts = new int[]{6000, 1};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{1, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{6000, 300};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{300, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
    }

    void splitTest(byte[] splitPoint, byte[][] familyNames, int[] rowCounts, int numVersions, int blockSize) throws Exception {
        TableName tableName = TableName.valueOf((String)"testForceSplit");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCounts.length; ++i) {
            sb.append("_").append(Integer.toString(rowCounts[i]));
        }
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
        final HTable table = TEST_UTIL.createTable(tableName, familyNames, numVersions, blockSize);
        int rowCount = 0;
        byte[] q = new byte[]{};
        for (int index = 0; index < familyNames.length; ++index) {
            ArrayList<Put> puts = new ArrayList<Put>(rowCounts[index]);
            for (int i = 0; i < rowCounts[index]; ++i) {
                byte[] k = Bytes.toBytes((int)i);
                Put put = new Put(k);
                put.add(familyNames[index], q, k);
                puts.add(put);
            }
            table.put(puts);
            if (rowCount >= rowCounts[index]) continue;
            rowCount = rowCounts[index];
        }
        NavigableMap m = table.getRegionLocations();
        LOG.info((Object)("Initial regions (" + m.size() + "): " + m));
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Scan scan = new Scan();
        ResultScanner scanner = table.getScanner(scan);
        int rows = 0;
        for (Result result : scanner) {
            ++rows;
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        scan = new Scan();
        scanner = table.getScanner(scan);
        scanner.next();
        this.admin.split(tableName, splitPoint);
        final AtomicInteger count = new AtomicInteger(0);
        Thread t = new Thread("CheckForSplit"){

            @Override
            public void run() {
                for (int i = 0; i < 45; ++i) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    NavigableMap regions = null;
                    try {
                        regions = table.getRegionLocations();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (regions == null) continue;
                    count.set(regions.size());
                    if (count.get() >= 2) {
                        LOG.info((Object)("Found: " + regions));
                        break;
                    }
                    LOG.debug((Object)"Cycle waiting on split");
                }
                LOG.debug((Object)("CheckForSplit thread exited, current region count: " + count.get()));
            }
        };
        t.setPriority(3);
        t.start();
        t.join();
        rows = 1;
        for (Result result : scanner) {
            if (++rows <= rowCount) continue;
            scanner.close();
            Assert.assertTrue((String)("Scanned more than expected (" + rowCount + ")"), (boolean)false);
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        NavigableMap regions = null;
        try {
            regions = table.getRegionLocations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)regions);
        Assert.assertEquals((long)2L, (long)regions.size());
        Set hRegionInfos = regions.keySet();
        HRegionInfo[] r = hRegionInfos.toArray(new HRegionInfo[hRegionInfos.size()]);
        if (splitPoint != null) {
            Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])r[0].getEndKey()));
            Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])r[1].getStartKey()));
            LOG.debug((Object)("Properly split on " + Bytes.toString((byte[])splitPoint)));
        } else if (familyNames.length > 1) {
            int splitKey = Bytes.toInt((byte[])r[0].getEndKey());
            int deltaForLargestFamily = Math.abs(rowCount / 2 - splitKey);
            LOG.debug((Object)("SplitKey=" + splitKey + "&deltaForLargestFamily=" + deltaForLargestFamily + ", r=" + r[0]));
            for (int index = 0; index < familyNames.length; ++index) {
                int delta = Math.abs(rowCounts[index] / 2 - splitKey);
                if (delta >= deltaForLargestFamily) continue;
                Assert.assertTrue((String)("Delta " + delta + " for family " + index + " should be at least deltaForLargestFamily " + deltaForLargestFamily), (boolean)false);
            }
        }
        TEST_UTIL.deleteTable(tableName);
        table.close();
    }

    @Test
    public void testSplitAndMergeWithReplicaTable() throws Exception {
        List<HRegion> oldRegions;
        TableName tableName = TableName.valueOf((String)"testSplitAndMergeWithReplicaTable");
        byte[] cf = "f".getBytes();
        this.createReplicaTable(tableName, cf);
        do {
            oldRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
            Thread.sleep(10L);
        } while (oldRegions.size() != 9);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        byte[] qualifier = "c".getBytes();
        Put put = new Put(new byte[]{49});
        put.add(cf, qualifier, "100".getBytes());
        puts.add(put);
        put = new Put(new byte[]{54});
        put.add(cf, qualifier, "100".getBytes());
        puts.add(put);
        put = new Put(new byte[]{56});
        put.add(cf, qualifier, "100".getBytes());
        puts.add(put);
        ht.put(puts);
        ht.flushCommits();
        ht.close();
        List regions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)TEST_UTIL.getConnection(), (TableName)tableName);
        boolean gotException = false;
        try {
            TEST_UTIL.getHBaseAdmin().split(((HRegionInfo)((Pair)regions.get(1)).getFirst()).getRegionName());
        }
        catch (IllegalArgumentException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getHBaseAdmin().split((ServerName)((Pair)regions.get(1)).getSecond(), (HRegionInfo)((Pair)regions.get(1)).getFirst(), new byte[]{49});
        }
        catch (IOException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getHBaseAdmin().mergeRegions(((HRegionInfo)((Pair)regions.get(1)).getFirst()).getEncodedNameAsBytes(), ((HRegionInfo)((Pair)regions.get(2)).getFirst()).getEncodedNameAsBytes(), true);
        }
        catch (IllegalArgumentException m) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        try {
            MasterProtos.DispatchMergingRegionsRequest request = RequestConverter.buildDispatchMergingRegionsRequest((byte[])((HRegionInfo)((Pair)regions.get(1)).getFirst()).getEncodedNameAsBytes(), (byte[])((HRegionInfo)((Pair)regions.get(2)).getFirst()).getEncodedNameAsBytes(), (boolean)true);
            TEST_UTIL.getHBaseAdmin().getConnection().getMaster().dispatchMergingRegions(null, request);
        }
        catch (ServiceException m) {
            Throwable t = m.getCause();
            do {
                if (!(t instanceof MergeRegionException)) continue;
                gotException = true;
                break;
            } while ((t = t.getCause()) != null);
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        if (!((ServerName)((Pair)regions.get(2)).getSecond()).equals(((Pair)regions.get(1)).getSecond())) {
            TEST_UTIL.moveRegionAndWait((HRegionInfo)((Pair)regions.get(2)).getFirst(), (ServerName)((Pair)regions.get(1)).getSecond());
        }
        try {
            AdminProtos.AdminService.BlockingInterface admin = TEST_UTIL.getHBaseAdmin().getConnection().getAdmin((ServerName)((Pair)regions.get(1)).getSecond());
            ProtobufUtil.mergeRegions(null, (AdminProtos.AdminService.BlockingInterface)admin, (HRegionInfo)((HRegionInfo)((Pair)regions.get(1)).getFirst()), (HRegionInfo)((HRegionInfo)((Pair)regions.get(2)).getFirst()), (boolean)true, null);
        }
        catch (MergeRegionException mm) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test
    public void testRegionStateCleanupFromAMMemoryAfterRegionSplitAndMerge() throws Exception {
        final TableName tableName = TableName.valueOf((String)"testRegionStateCleanupFromAMMemoryAfterRegionSplitAndMerge");
        this.createReplicaTable(tableName, "f".getBytes());
        final int regionReplication = this.admin.getTableDescriptor(tableName).getRegionReplication();
        List regions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)TEST_UTIL.getConnection(), (TableName)tableName);
        Assert.assertEquals((long)9L, (long)regions.size());
        final int primaryRegionCount = regions.size() / regionReplication;
        final AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        List splitRegions = (List)am.getRegionStates().getRegionByStateOfTable(tableName).get(RegionState.State.SPLIT);
        Assert.assertEquals((long)0L, (long)splitRegions.size());
        byte[] regionName = ((HRegionInfo)((Pair)regions.get(0)).getFirst()).getRegionName();
        try {
            TEST_UTIL.getHBaseAdmin().split(regionName, Bytes.toBytes((int)50));
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)("Exception occured during region split" + ex));
        }
        TEST_UTIL.waitFor(60000L, 500L, new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return ((List)am.getRegionStates().getRegionByStateOfTable(tableName).get(RegionState.State.OPEN)).size() == (primaryRegionCount + 1) * regionReplication;
            }
        });
        regions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)TEST_UTIL.getConnection(), (TableName)tableName);
        Assert.assertEquals((long)12L, (long)regions.size());
        final int primaryRegionCountAfterSplit = regions.size() / regionReplication;
        splitRegions = (List)am.getRegionStates().getRegionByStateOfTable(tableName).get(RegionState.State.SPLIT);
        Assert.assertEquals((long)1L, (long)splitRegions.size());
        HRegionInfo regionA = (HRegionInfo)((Pair)regions.get(3)).getFirst();
        HRegionInfo regionB = (HRegionInfo)((Pair)regions.get(6)).getFirst();
        try {
            TEST_UTIL.getHBaseAdmin().mergeRegions(regionA.getRegionName(), regionB.getRegionName(), true);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)("Exception occured during region merge" + ex));
        }
        TEST_UTIL.waitFor(60000L, 500L, new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return ((List)am.getRegionStates().getRegionByStateOfTable(tableName).get(RegionState.State.OPEN)).size() == (primaryRegionCountAfterSplit - 1) * regionReplication;
            }
        });
        regions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (Connection)TEST_UTIL.getConnection(), (TableName)tableName);
        Assert.assertEquals((long)9L, (long)regions.size());
        List offlineRegions = (List)am.getRegionStates().getRegionByStateOfTable(tableName).get(RegionState.State.OFFLINE);
        Assert.assertEquals((long)0L, (long)offlineRegions.size());
    }

    private byte[] createReplicaTable(TableName tableName, byte[] cf) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setRegionReplication(3);
        HColumnDescriptor hcd = new HColumnDescriptor(cf);
        desc.addFamily(hcd);
        byte[][] splitRows = new byte[][]{{52}, {55}};
        TEST_UTIL.getHBaseAdmin().createTable(desc, (byte[][])splitRows);
        return cf;
    }

    @Test(expected=IllegalArgumentException.class, timeout=300000L)
    public void testEmptyHTableDescriptor() throws IOException {
        this.admin.createTable(new HTableDescriptor());
    }

    @Test(expected=IllegalArgumentException.class, timeout=300000L)
    public void testInvalidHColumnDescriptor() throws IOException {
        new HColumnDescriptor("/cfamily/name");
    }

    @Test(timeout=300000L)
    public void testEnableDisableAddColumnDeleteColumn() throws Exception {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        TableName tableName = TableName.valueOf((String)"testEnableDisableAddColumnDeleteColumn");
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!ZKTableStateClientSideReader.isEnabledTable((ZooKeeperWatcher)zkw, (TableName)TableName.valueOf((String)"testEnableDisableAddColumnDeleteColumn"))) {
            Thread.sleep(10L);
        }
        this.admin.disableTable(tableName);
        try {
            new HTable(TEST_UTIL.getConfiguration(), tableName);
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        this.admin.addColumn(tableName, new HColumnDescriptor("col2"));
        this.admin.enableTable(tableName);
        try {
            this.admin.deleteColumn(tableName, Bytes.toBytes((String)"col2"));
        }
        catch (TableNotDisabledException e) {
            LOG.info((Object)e);
        }
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }

    @Test(timeout=300000L)
    public void testDeleteLastColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)"testDeleteLastColumnFamily");
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!this.admin.isTableEnabled(TableName.valueOf((String)"testDeleteLastColumnFamily"))) {
            Thread.sleep(10L);
        }
        try {
            this.admin.deleteColumn(tableName, HConstants.CATALOG_FAMILY);
            Assert.fail((String)"Should have failed to delete the only column family of a table");
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        this.admin.disableTable(tableName);
        try {
            this.admin.deleteColumn(tableName, HConstants.CATALOG_FAMILY);
            Assert.fail((String)"Should have failed to delete the only column family of a table");
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        this.admin.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHFileReplication() throws Exception {
        TableName name = TableName.valueOf((String)"testHFileReplication");
        String fn1 = "rep1";
        HColumnDescriptor hcd1 = new HColumnDescriptor(fn1);
        hcd1.setDFSReplication((short)1);
        String fn = "defaultRep";
        HColumnDescriptor hcd = new HColumnDescriptor(fn);
        HTableDescriptor htd = new HTableDescriptor(name);
        htd.addFamily(hcd);
        htd.addFamily(hcd1);
        HTable table = TEST_UTIL.createTable(htd, (byte[][])null);
        TEST_UTIL.waitTableAvailable(name);
        Put p = new Put(Bytes.toBytes((String)"defaultRep_rk"));
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] v1 = Bytes.toBytes((String)"v1");
        p.addColumn(Bytes.toBytes((String)fn), q1, v1);
        ArrayList<Put> puts = new ArrayList<Put>(2);
        puts.add(p);
        p = new Put(Bytes.toBytes((String)"rep1_rk"));
        p.addColumn(Bytes.toBytes((String)fn1), q1, v1);
        puts.add(p);
        try {
            table.put(puts);
            this.admin.flush(name);
            List<HRegion> regions = TEST_UTIL.getMiniHBaseCluster().getRegions(name);
            for (HRegion r : regions) {
                Store store = r.getStore(Bytes.toBytes((String)fn));
                for (StoreFile sf : store.getStorefiles()) {
                    Assert.assertTrue((boolean)sf.toString().contains(fn));
                    Assert.assertTrue((String)("Column family " + fn + " should have 3 copies"), (FSUtils.getDefaultReplication((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)sf.getPath()) == sf.getFileInfo().getFileStatus().getReplication() ? 1 : 0) != 0);
                }
                store = r.getStore(Bytes.toBytes((String)fn1));
                for (StoreFile sf : store.getStorefiles()) {
                    Assert.assertTrue((boolean)sf.toString().contains(fn1));
                    Assert.assertTrue((String)("Column family " + fn1 + " should have only 1 copy"), (1 == sf.getFileInfo().getFileStatus().getReplication() ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (this.admin.isTableEnabled(name)) {
                this.admin.disableTable(name);
                this.admin.deleteTable(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMergeWithFullRegionName");
        HColumnDescriptor cd = new HColumnDescriptor("d");
        HTableDescriptor td = new HTableDescriptor(tableName);
        td.addFamily(cd);
        byte[][] splitRows = new byte[][]{{51}, {54}};
        try {
            TEST_UTIL.createTable(td, (byte[][])splitRows);
            TEST_UTIL.waitTableAvailable(tableName);
            List tableRegions = this.admin.getTableRegions(tableName);
            Assert.assertEquals((long)3L, (long)this.admin.getTableRegions(tableName).size());
            HRegionInfo regionA = (HRegionInfo)tableRegions.get(0);
            HRegionInfo regionB = (HRegionInfo)tableRegions.get(1);
            this.admin.mergeRegions(regionA.getRegionName(), regionB.getRegionName(), false);
            Thread.sleep(1000L);
            Assert.assertEquals((long)2L, (long)this.admin.getTableRegions(tableName).size());
            tableRegions = this.admin.getTableRegions(tableName);
            regionA = (HRegionInfo)tableRegions.get(0);
            regionB = (HRegionInfo)tableRegions.get(1);
            this.admin.mergeRegions(regionA.getEncodedNameAsBytes(), regionB.getEncodedNameAsBytes(), false);
            Thread.sleep(1000L);
            Assert.assertEquals((long)1L, (long)this.admin.getTableRegions(tableName).size());
        }
        finally {
            this.admin.disableTable(tableName);
            this.admin.deleteTable(tableName);
        }
    }
}

