/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class MutationSerialization
implements Serialization<Mutation> {
    public boolean accept(Class<?> c) {
        return Mutation.class.isAssignableFrom(c);
    }

    public Deserializer<Mutation> getDeserializer(Class<Mutation> c) {
        return new MutationDeserializer();
    }

    public Serializer<Mutation> getSerializer(Class<Mutation> c) {
        return new MutationSerializer();
    }

    private static class MutationSerializer
    implements Serializer<Mutation> {
        private OutputStream out;

        private MutationSerializer() {
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(Mutation mutation) throws IOException {
            ClientProtos.MutationProto.MutationType type;
            if (mutation instanceof Put) {
                type = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                type = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new IllegalArgumentException("Only Put and Delete are supported");
            }
            ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)type, (Mutation)mutation).writeDelimitedTo(this.out);
        }
    }

    private static class MutationDeserializer
    implements Deserializer<Mutation> {
        private InputStream in;

        private MutationDeserializer() {
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Mutation deserialize(Mutation mutation) throws IOException {
            ClientProtos.MutationProto.Builder builder = ClientProtos.MutationProto.newBuilder();
            ProtobufUtil.mergeDelimitedFrom((Message.Builder)builder, (InputStream)this.in);
            ClientProtos.MutationProto proto = builder.build();
            return ProtobufUtil.toMutation((ClientProtos.MutationProto)proto);
        }

        public void open(InputStream in) throws IOException {
            this.in = in;
        }
    }
}

