/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationAdminWithClusters
extends TestReplicationBase {
    static Connection connection1;
    static Connection connection2;
    static Admin admin1;
    static Admin admin2;
    static ReplicationAdmin adminExt;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestReplicationBase.setUpBeforeClass();
        connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        connection2 = ConnectionFactory.createConnection((Configuration)conf2);
        admin1 = connection1.getAdmin();
        admin2 = connection2.getAdmin();
        adminExt = new ReplicationAdmin(conf1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        admin1.close();
        admin2.close();
        adminExt.close();
        connection1.close();
        connection2.close();
        TestReplicationBase.tearDownAfterClass();
    }

    @Test(timeout=300000L)
    public void testEnableReplicationWhenSlaveClusterDoesntHaveTable() throws Exception {
        admin2.disableTable(tableName);
        admin2.deleteTable(tableName);
        Assert.assertFalse((boolean)admin2.tableExists(tableName));
        adminExt.enableTableRep(tableName);
        Assert.assertTrue((boolean)admin2.tableExists(tableName));
    }

    @Test(timeout=300000L)
    public void testEnableReplicationWhenReplicationNotEnabled() throws Exception {
        HTableDescriptor table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            fam.setScope(0);
        }
        admin1.disableTable(tableName);
        admin1.modifyTable(tableName, table);
        admin1.enableTable(tableName);
        admin2.disableTable(tableName);
        admin2.modifyTable(tableName, table);
        admin2.enableTable(tableName);
        adminExt.enableTableRep(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)1L);
        }
    }

    @Test(timeout=300000L)
    public void testEnableReplicationWhenTableDescriptorIsNotSameInClusters() throws Exception {
        HTableDescriptor table = admin2.getTableDescriptor(tableName);
        HColumnDescriptor f = new HColumnDescriptor("newFamily");
        table.addFamily(f);
        admin2.disableTable(tableName);
        admin2.modifyTable(tableName, table);
        admin2.enableTable(tableName);
        try {
            adminExt.enableTableRep(tableName);
            Assert.fail((String)"Exception should be thrown if table descriptors in the clusters are not same.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        admin1.disableTable(tableName);
        admin1.modifyTable(tableName, table);
        admin1.enableTable(tableName);
        adminExt.enableTableRep(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)1L);
        }
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableReplication() throws Exception {
        adminExt.disableTableRep(tableName);
        HTableDescriptor table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)0L);
        }
        table = admin2.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)0L);
        }
        adminExt.enableTableRep(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)1L);
        }
    }

    @Test(timeout=300000L, expected=TableNotFoundException.class)
    public void testDisableReplicationForNonExistingTable() throws Exception {
        adminExt.disableTableRep(TableName.valueOf((String)"nonExistingTable"));
    }

    @Test(timeout=300000L, expected=TableNotFoundException.class)
    public void testEnableReplicationForNonExistingTable() throws Exception {
        adminExt.enableTableRep(TableName.valueOf((String)"nonExistingTable"));
    }

    @Test(timeout=300000L, expected=IllegalArgumentException.class)
    public void testDisableReplicationWhenTableNameAsNull() throws Exception {
        adminExt.disableTableRep(null);
    }

    @Test(timeout=300000L, expected=IllegalArgumentException.class)
    public void testEnableReplicationWhenTableNameAsNull() throws Exception {
        adminExt.enableTableRep(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testEnableReplicationForExplicitSetTableCfs() throws Exception {
        TableName tn = TableName.valueOf((String)"testEnableReplicationForSetTableCfs");
        String peerId = "2";
        if (admin2.isTableAvailable(tableName)) {
            admin2.disableTable(tableName);
            admin2.deleteTable(tableName);
        }
        Assert.assertFalse((String)"Table should not exists in the peer cluster", (boolean)admin2.isTableAvailable(tableName));
        HashMap<TableName, Object> tableCfs = new HashMap<TableName, Object>();
        tableCfs.put(tn, null);
        try {
            adminExt.setPeerTableCFs(peerId, tableCfs);
            adminExt.enableTableRep(tableName);
            Assert.assertFalse((String)"Table should not be created if user has set table cfs explicitly for the peer and this is not part of that collection", (boolean)admin2.isTableAvailable(tableName));
            tableCfs.put(tableName, null);
            adminExt.setPeerTableCFs(peerId, tableCfs);
            adminExt.enableTableRep(tableName);
            Assert.assertTrue((String)"Table should be created if user has explicitly added table into table cfs collection", (boolean)admin2.isTableAvailable(tableName));
        }
        finally {
            adminExt.removePeerTableCFs(peerId, adminExt.getPeerTableCFs(peerId));
            adminExt.disableTableRep(tableName);
        }
    }
}

