/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class BackupMasterStatusTmplImpl
extends AbstractTemplateImpl
implements BackupMasterStatusTmpl.Intf {
    private final HMaster master;

    protected static BackupMasterStatusTmpl.ImplData __jamon_setOptionalArguments(BackupMasterStatusTmpl.ImplData p_implData) {
        return p_implData;
    }

    public BackupMasterStatusTmplImpl(TemplateManager p_templateManager, BackupMasterStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)BackupMasterStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        int infoPort;
        List<ServerName> masters = null;
        MasterAddressTracker masterAddressTracker = this.master.getMasterAddressTracker();
        if (this.master.isActiveMaster()) {
            ClusterStatus status = this.master.getClusterStatus();
            masters = status.getBackupMasters();
        } else {
            ServerName sn;
            ServerName serverName = sn = masterAddressTracker == null ? null : masterAddressTracker.getMasterAddress();
            assert (sn != null) : "Failed to retreive master's ServerName!";
            masters = Collections.singletonList(sn);
        }
        Object[] serverNames = masters.toArray(new ServerName[masters.size()]);
        int n = infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getMasterInfoPort();
        if (!this.master.isActiveMaster()) {
            jamonWriter.write("\n    ");
            if (serverNames[0] != null) {
                jamonWriter.write("\n        <h2>Master</h2>\n        <a href=\"//");
                Escaping.HTML.write(StandardEmitter.valueOf((String)serverNames[0].getHostname()), jamonWriter);
                jamonWriter.write(":");
                Escaping.HTML.write(StandardEmitter.valueOf((int)infoPort), jamonWriter);
                jamonWriter.write("/master-status\" target=\"_blank\">");
                Escaping.HTML.write(StandardEmitter.valueOf((String)serverNames[0].getHostname()), jamonWriter);
                jamonWriter.write("</a>\n    ");
            } else {
                jamonWriter.write("\n        Unable to parse master hostname.\n    ");
            }
            jamonWriter.write("\n");
        } else {
            jamonWriter.write("\n    <h2>Backup Masters</h2>\n\n    <table class=\"table table-striped\">\n    <tr>\n        <th>ServerName</th>\n        <th>Port</th>\n        <th>Start Time</th>\n    </tr>\n    ");
            Arrays.sort(serverNames);
            for (Object serverName : serverNames) {
                infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getBackupMasterInfoPort((ServerName)serverName);
                jamonWriter.write("<tr>\n        <td><a href=\"//");
                Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getHostname()), jamonWriter);
                jamonWriter.write(":");
                Escaping.HTML.write(StandardEmitter.valueOf((int)infoPort), jamonWriter);
                jamonWriter.write("/master-status\" target=\"_blank\">");
                Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getHostname()), jamonWriter);
                jamonWriter.write("</a>\n        </td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)serverName.getPort()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(serverName.getStartcode())), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("<tr><td>Total:");
            Escaping.HTML.write(StandardEmitter.valueOf((int)(masters != null ? masters.size() : 0)), jamonWriter);
            jamonWriter.write("</td>\n    </table>\n");
        }
        jamonWriter.write("\n");
    }
}

