/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.util.PairOfSameType;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface SplitTransaction {
    public boolean prepare() throws IOException;

    public PairOfSameType<Region> execute(Server var1, RegionServerServices var2) throws IOException;

    public boolean rollback(Server var1, RegionServerServices var2) throws IOException;

    public SplitTransaction registerTransactionListener(TransactionListener var1);

    public List<JournalEntry> getJournal();

    public Server getServer();

    public RegionServerServices getRegionServerServices();

    public static interface TransactionListener {
        public void transition(SplitTransaction var1, SplitTransactionPhase var2, SplitTransactionPhase var3) throws IOException;

        public void rollback(SplitTransaction var1, SplitTransactionPhase var2, SplitTransactionPhase var3);
    }

    public static interface JournalEntry {
        public SplitTransactionPhase getPhase();

        public long getTimeStamp();
    }

    public static enum SplitTransactionPhase {
        STARTED,
        PREPARED,
        BEFORE_PRE_SPLIT_HOOK,
        AFTER_PRE_SPLIT_HOOK,
        SET_SPLITTING,
        CREATE_SPLIT_DIR,
        CLOSED_PARENT_REGION,
        OFFLINED_PARENT,
        STARTED_REGION_A_CREATION,
        STARTED_REGION_B_CREATION,
        OPENED_REGION_A,
        OPENED_REGION_B,
        PONR,
        BEFORE_POST_SPLIT_HOOK,
        AFTER_POST_SPLIT_HOOK,
        COMPLETED;

    }
}

