// Autogenerated Jamon implementation
// /data/tmp/hbase-0.98.1RC3/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 26, 9
import org.apache.hadoop.hbase.util.Bytes;
// 27, 9
import org.apache.hadoop.hbase.HRegionInfo;
// 28, 9
import org.apache.hadoop.hbase.ServerName;
// 29, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 30, 9
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 31, 9
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 32, 9
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<HRegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 34, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 34, 60
      jamonWriter.write("\n\n    ");
      // 36, 5
      
        Collections.sort(onlineRegions);
    
      // 40, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 50, 17
      {
        // 50, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 50, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 53, 17
      {
        // 53, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 53, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 56, 17
      {
        // 56, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 56, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 59, 17
      {
        // 59, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 59, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 62, 17
      {
        // 62, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 62, 67
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or 'catalog' tables in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If region has both an empty start and an empty end key, its the only region in the table.  See\n    <a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 77, 1
    else
    {
      // 77, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 79, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 102, 1
  private void __jamon_innerUnit__requestStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 106, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n\n        ");
    // 113, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 113, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 116, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 119, 13
      jamonWriter.write("<td>");
      // 119, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 119, 48
      jamonWriter.write("</td>\n            ");
      // 120, 13
      if (load != null )
      {
        // 120, 33
        jamonWriter.write("\n            <td>");
        // 121, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getReadRequestsCount()), jamonWriter);
        // 121, 50
        jamonWriter.write("</td>\n            <td>");
        // 122, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getWriteRequestsCount()), jamonWriter);
        // 122, 51
        jamonWriter.write("</td>\n            ");
      }
      // 123, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 125, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 200, 1
  private void __jamon_innerUnit__memstoreStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 204, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n\n        ");
    // 210, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 210, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 213, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 216, 13
      jamonWriter.write("<td>");
      // 216, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 216, 48
      jamonWriter.write("</td>\n            ");
      // 217, 13
      if (load != null )
      {
        // 217, 33
        jamonWriter.write("\n            <td>");
        // 218, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getMemstoreSizeMB()), jamonWriter);
        // 218, 47
        jamonWriter.write("m</td>\n            ");
      }
      // 219, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 221, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 166, 1
  private void __jamon_innerUnit__compactStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 170, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting KVs</th>\n            <th>Num. Compacted KVs</th>\n            <th>Compaction Progress</th>\n        </tr>\n\n        ");
    // 178, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 178, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 181, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            if  (load != null && load.getTotalCompactingKVs() > 0) {
            percentDone = String.format("%.2f", 100 *
            ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
            }
        
      // 189, 13
      jamonWriter.write("<td>");
      // 189, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 189, 48
      jamonWriter.write("</td>\n            ");
      // 190, 13
      if (load != null )
      {
        // 190, 33
        jamonWriter.write("\n            <td>");
        // 191, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalCompactingKVs()), jamonWriter);
        // 191, 51
        jamonWriter.write("</td>\n            <td>");
        // 192, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getCurrentCompactedKVs()), jamonWriter);
        // 192, 52
        jamonWriter.write("</td>\n            <td>");
        // 193, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 193, 34
        jamonWriter.write("</td>\n            ");
      }
      // 194, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 196, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 81, 1
  private void __jamon_innerUnit__baseInfo(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 85, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n        </tr>\n\n        ");
    // 92, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 92, 46
      jamonWriter.write("\n        <tr>\n            <td>");
      // 94, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 94, 48
      jamonWriter.write("</td>\n            <td>");
      // 95, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getStartKey())), jamonWriter);
      // 95, 60
      jamonWriter.write("</td>\n            <td>");
      // 96, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getEndKey())), jamonWriter);
      // 96, 58
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 98, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 130, 1
  private void __jamon_innerUnit__storeStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 134, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n        </tr>\n\n        ");
    // 145, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 145, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 148, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 151, 13
      jamonWriter.write("<td>");
      // 151, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 151, 48
      jamonWriter.write("</td>\n            ");
      // 152, 13
      if (load != null )
      {
        // 152, 33
        jamonWriter.write("\n            <td>");
        // 153, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStores()), jamonWriter);
        // 153, 39
        jamonWriter.write("</td>\n            <td>");
        // 154, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefiles()), jamonWriter);
        // 154, 43
        jamonWriter.write("</td>\n            <td>");
        // 155, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStoreUncompressedSizeMB()), jamonWriter);
        // 155, 56
        jamonWriter.write("m</td>\n            <td>");
        // 156, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefileSizeMB()), jamonWriter);
        // 156, 48
        jamonWriter.write("m</td>\n            <td>");
        // 157, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticIndexSizeKB()), jamonWriter);
        // 157, 55
        jamonWriter.write("k</td>\n            <td>");
        // 158, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticBloomSizeKB()), jamonWriter);
        // 158, 55
        jamonWriter.write("k</td>\n            ");
      }
      // 159, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 161, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
}
