// Autogenerated Jamon implementation
// /data/tmp/hbase-0.98.1RC3/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RSStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 25, 1
import java.util.*;
// 26, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 28, 1
import org.apache.hadoop.hbase.ServerName;
// 29, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 30, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 31, 1
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 32, 1
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;

public class RSStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.Intf

{
  private final HRegionServer regionServer;
  private final String filter;
  private final String format;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    return p_implData;
  }
  public RSStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 34, 1
    if (format.equals("json") )
    {
      // 34, 30
      jamonWriter.write("\n  ");
      // 35, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_6 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_6.setFilter(filter);
        __jamon__var_6.setFormat("json" );
        __jamon__var_6.renderNoFlush(jamonWriter);
      }
      // 35, 68
      jamonWriter.write("\n  ");
      // 36, 3
      return; 
    }
    // 37, 7
    jamonWriter.write("\n");
    // 38, 1
    
  ServerInfo serverInfo = ProtobufUtil.getServerInfo(regionServer);
  ServerName serverName = ProtobufUtil.toServerName(serverInfo.getServerName());
  List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(regionServer);
  int masterInfoPort = regionServer.getConfiguration().getInt("hbase.master.info.port", 60010);
  MasterAddressTracker masterAddressTracker = regionServer.getMasterAddressTracker();
  ServerName masterServerName = masterAddressTracker == null ? null
    : masterAddressTracker.getMasterAddress();

    // 47, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HBase Region Server: ");
    // 54, 33
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
    // 54, 63
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/rs-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 82, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 82, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 84, 23
    jamonWriter.write("\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n  <div class=\"container\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>RegionServer <small>");
    // 94, 37
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 94, 53
    jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n\n    <section>\n    <h2>Server Metrics</h2>\n    ");
    // 101, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl(this.getTemplateManager());
      __jamon__var_7.renderNoFlush(jamonWriter, regionServer.getMetrics().getRegionServerWrapper());
    }
    // 101, 89
    jamonWriter.write("\n    </section>\n\n    <section>\n    ");
    // 105, 5
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_8.setFilter(filter );
      __jamon__var_8.renderNoFlush(jamonWriter);
    }
    // 105, 53
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Regions</h2>\n    ");
    // 110, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl(this.getTemplateManager());
      __jamon__var_9.renderNoFlush(jamonWriter, regionServer, onlineRegions);
    }
    // 110, 86
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Software Attributes</h2>\n    <table id=\"attributes_table\" class=\"table table-striped\">\n        <tr>\n            <th>Attribute Name</th>\n            <th>Value</th>\n            <th>Description</th>\n        </tr>\n        <tr>\n            <td>HBase Version</td>\n            <td>");
    // 123, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 123, 76
    jamonWriter.write(", r");
    // 123, 79
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 123, 139
    jamonWriter.write("</td>\n            <td>HBase version and revision</td>\n        </tr>\n        <tr>\n            <td>HBase Compiled</td>\n            <td>");
    // 128, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 128, 73
    jamonWriter.write(", ");
    // 128, 75
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 128, 131
    jamonWriter.write("</td>\n            <td>When HBase version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>Zookeeper Quorum</td>\n            <td>");
    // 133, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(regionServer.getZooKeeper().getQuorum()), jamonWriter);
    // 133, 62
    jamonWriter.write("</td>\n            <td>Addresses of all registered ZK servers</td>\n        </tr>\n        <tr>\n            <td>Coprocessors</td>\n            <td>");
    // 138, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(regionServer.getCoprocessors())), jamonWriter);
    // 138, 80
    jamonWriter.write("</td>\n            <td>Coprocessors currently loaded by this regionserver</td>\n        </tr>\n        <tr>\n            <td>RS Start Time</td>\n            <td>");
    // 143, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(regionServer.getStartcode())), jamonWriter);
    // 143, 60
    jamonWriter.write("</td>\n            <td>Date stamp of when this region server was started</td>\n        </tr>\n        <tr>\n            <td>HBase Master</td>\n            <td>\n                ");
    // 149, 17
    if ((masterInfoPort < 0) )
    {
      // 149, 45
      jamonWriter.write("\n                No hbase.master.info.port found\n                ");
    }
    // 151, 17
    else if (masterServerName == null )
    {
      // 151, 53
      jamonWriter.write("\n                No master found\n                ");
    }
    // 153, 17
    else
    {
      // 153, 24
      jamonWriter.write("\n                ");
      // 154, 17
      
                String host = masterServerName.getHostname() + ":" + masterInfoPort;
                String url = "//" + host + "/";
                
      // 158, 17
      jamonWriter.write("<a href=\"");
      // 158, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 158, 35
      jamonWriter.write("\">");
      // 158, 37
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(host), jamonWriter);
      // 158, 47
      jamonWriter.write("</a>\n                ");
    }
    // 159, 23
    jamonWriter.write("\n            </td>\n            <td>Address of HBase Master</td>\n        </tr>\n    </table>\n    </section>\n    </div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n");
  }
  
  
}
