/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import org.apache.hadoop.hbase.procedure2.LockStatus;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;

public class LockAndQueue
extends ProcedureDeque
implements LockStatus {
    private Procedure<?> exclusiveLockOwnerProcedure = null;
    private int sharedLock = 0;

    @Override
    public boolean isLocked() {
        return this.hasExclusiveLock() || this.sharedLock > 0;
    }

    @Override
    public boolean hasExclusiveLock() {
        return this.exclusiveLockOwnerProcedure != null;
    }

    @Override
    public boolean isLockOwner(long procId) {
        return this.getExclusiveLockProcIdOwner() == procId;
    }

    @Override
    public boolean hasParentLock(Procedure proc) {
        return proc.hasParent() && (this.isLockOwner(proc.getParentProcId()) || this.isLockOwner(proc.getRootProcId()));
    }

    @Override
    public boolean hasLockAccess(Procedure proc) {
        return this.isLockOwner(proc.getProcId()) || this.hasParentLock(proc);
    }

    @Override
    public Procedure<?> getExclusiveLockOwnerProcedure() {
        return this.exclusiveLockOwnerProcedure;
    }

    @Override
    public long getExclusiveLockProcIdOwner() {
        if (this.exclusiveLockOwnerProcedure == null) {
            return Long.MIN_VALUE;
        }
        return this.exclusiveLockOwnerProcedure.getProcId();
    }

    @Override
    public int getSharedLockCount() {
        return this.sharedLock;
    }

    public boolean trySharedLock() {
        if (this.hasExclusiveLock()) {
            return false;
        }
        ++this.sharedLock;
        return true;
    }

    public boolean releaseSharedLock() {
        return --this.sharedLock == 0;
    }

    public boolean tryExclusiveLock(Procedure proc) {
        if (this.isLocked()) {
            return this.hasLockAccess(proc);
        }
        this.exclusiveLockOwnerProcedure = proc;
        return true;
    }

    public boolean releaseExclusiveLock(Procedure proc) {
        if (this.isLockOwner(proc.getProcId())) {
            this.exclusiveLockOwnerProcedure = null;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "exclusiveLockOwner=" + (this.hasExclusiveLock() ? Long.valueOf(this.getExclusiveLockProcIdOwner()) : "NONE") + ", sharedLockCount=" + this.getSharedLockCount() + ", waitingProcCount=" + this.size();
    }
}

