/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TimeoutBlockingQueue<E> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitCond = this.lock.newCondition();
    private final TimeoutRetriever<? super E> timeoutRetriever;
    private E[] objects;
    private int head = 0;
    private int tail = 0;

    public TimeoutBlockingQueue(TimeoutRetriever<? super E> timeoutRetriever) {
        this(32, timeoutRetriever);
    }

    public TimeoutBlockingQueue(int capacity, TimeoutRetriever<? super E> timeoutRetriever) {
        this.objects = new Object[capacity];
        this.timeoutRetriever = timeoutRetriever;
    }

    public void dump() {
        for (int i = 0; i < this.objects.length; ++i) {
            if (i == this.head) {
                System.out.print("[" + this.objects[i] + "] ");
                continue;
            }
            if (i == this.tail) {
                System.out.print("]" + this.objects[i] + "[ ");
                continue;
            }
            System.out.print(this.objects[i] + " ");
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            if (this.head != this.tail) {
                for (int i = this.head; i < this.tail; ++i) {
                    this.objects[i] = null;
                }
                this.head = 0;
                this.tail = 0;
                this.waitCond.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            this.addElement(e);
            this.waitCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(E e) {
        if (e == null) {
            return false;
        }
        this.lock.lock();
        try {
            for (int i = 0; i < this.objects.length; ++i) {
                if (!e.equals(this.objects[i])) continue;
                this.objects[i] = null;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    public E poll() {
        this.lock.lock();
        try {
            if (this.isEmpty()) {
                this.waitCond.await();
                E e = null;
                return e;
            }
            E elem = this.objects[this.head];
            long nanos = this.getNanosTimeout(elem);
            E e = (nanos = this.waitCond.awaitNanos(nanos)) > 0L ? null : (E)this.removeFirst();
            return e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            E e2 = null;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.tail - this.head;
    }

    public boolean isEmpty() {
        return this.tail - this.head == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll() {
        this.lock.lock();
        try {
            this.waitCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addElement(E elem) {
        int size = this.tail - this.head;
        if (this.objects.length - size == 0) {
            int capacity = size + (size < 64 ? size + 2 : size >> 1);
            Object[] newObjects = new Object[capacity];
            if (this.compareTimeouts(this.objects[this.tail - 1], elem) <= 0) {
                System.arraycopy(this.objects, this.head, newObjects, 0, this.tail);
                this.tail -= this.head;
                newObjects[this.tail++] = elem;
            } else if (this.compareTimeouts(this.objects[this.head], elem) > 0) {
                System.arraycopy(this.objects, this.head, newObjects, 1, this.tail);
                newObjects[0] = elem;
                this.tail -= this.head - 1;
            } else {
                int index = this.upperBound(this.head, this.tail - 1, elem);
                int newIndex = index - this.head;
                System.arraycopy(this.objects, this.head, newObjects, 0, newIndex);
                newObjects[newIndex] = elem;
                System.arraycopy(this.objects, index, newObjects, newIndex + 1, this.tail - index);
                this.tail -= this.head - 1;
            }
            this.head = 0;
            this.objects = newObjects;
        } else {
            if (this.tail == this.objects.length) {
                this.tail -= this.head;
                System.arraycopy(this.objects, this.head, this.objects, 0, this.tail);
                this.head = 0;
            }
            if (this.tail == this.head || this.compareTimeouts(this.objects[this.tail - 1], elem) <= 0) {
                this.objects[this.tail++] = elem;
            } else if (this.head > 0 && this.compareTimeouts(this.objects[this.head], elem) > 0) {
                this.objects[--this.head] = elem;
            } else {
                int index = this.upperBound(this.head, this.tail - 1, elem);
                System.arraycopy(this.objects, index, this.objects, index + 1, this.tail - index);
                this.objects[index] = elem;
                ++this.tail;
            }
        }
    }

    private E removeFirst() {
        E elem = this.objects[this.head];
        this.objects[this.head] = null;
        this.head = (this.head + 1) % this.objects.length;
        if (this.head == 0) {
            this.tail = 0;
        }
        return elem;
    }

    private int upperBound(int start, int end, E key) {
        while (start < end) {
            int mid = start + end >>> 1;
            E mitem = this.objects[mid];
            int cmp = this.compareTimeouts(mitem, key);
            if (cmp > 0) {
                end = mid;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    private int compareTimeouts(E a, E b) {
        long t2;
        long t1 = this.getNanosTimeout(a);
        return t1 < (t2 = this.getNanosTimeout(b)) ? -1 : (t1 > t2 ? 1 : 0);
    }

    private long getNanosTimeout(E obj) {
        if (obj == null) {
            return 0L;
        }
        TimeUnit unit = this.timeoutRetriever.getTimeUnit(obj);
        long timeout = this.timeoutRetriever.getTimeout(obj);
        return unit.toNanos(timeout);
    }

    public static interface TimeoutRetriever<T> {
        public long getTimeout(T var1);

        public TimeUnit getTimeUnit(T var1);
    }
}

