/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PrefixTreeCell
extends ByteBufferCell
implements SettableSequenceId,
Comparable<Cell> {
    protected CellComparator comparator = CellComparatorImpl.COMPARATOR;
    public static final KeyValue.Type[] TYPES = new KeyValue.Type[256];
    public static final KeyValue.Type DEFAULT_TYPE;
    protected ByteBuff block;
    protected boolean includeMvccVersion;
    protected byte[] rowBuffer;
    protected int rowLength;
    protected byte[] familyBuffer;
    protected int familyOffset;
    protected int familyLength;
    protected byte[] qualifierBuffer;
    protected int qualifierOffset;
    protected int qualifierLength;
    protected Long timestamp;
    protected Long mvccVersion;
    protected KeyValue.Type type;
    protected int absoluteValueOffset;
    protected int valueLength;
    protected byte[] tagsBuffer;
    protected int tagsOffset;
    protected int tagsLength;
    protected ObjectIntPair<ByteBuffer> pair = new ObjectIntPair();

    public String toString() {
        return this.getKeyValueString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cell)) {
            return false;
        }
        return PrivateCellUtil.equalsIgnoreMvccVersion((Cell)this, (Cell)((Cell)obj));
    }

    public int hashCode() {
        return this.calculateHashForKey((Cell)this);
    }

    private int calculateHashForKey(Cell cell) {
        int rowHash = Bytes.hashCode((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength());
        int familyHash = Bytes.hashCode((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength());
        int qualifierHash = Bytes.hashCode((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
        int hash = 31 * rowHash + familyHash;
        hash = 31 * hash + qualifierHash;
        hash = 31 * hash + (int)cell.getTimestamp();
        hash = 31 * hash + cell.getTypeByte();
        return hash;
    }

    @Override
    public int compareTo(Cell other) {
        return this.comparator.compare((Cell)this, other);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSequenceId() {
        if (!this.includeMvccVersion) {
            return 0L;
        }
        return this.mvccVersion;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public byte[] getRowArray() {
        return this.rowBuffer;
    }

    public int getRowOffset() {
        return 0;
    }

    public short getRowLength() {
        return (short)this.rowLength;
    }

    public byte[] getFamilyArray() {
        return this.familyBuffer;
    }

    public int getFamilyOffset() {
        return this.familyOffset;
    }

    public byte getFamilyLength() {
        return (byte)this.familyLength;
    }

    public byte[] getQualifierArray() {
        return this.qualifierBuffer;
    }

    public int getQualifierOffset() {
        return this.qualifierOffset;
    }

    public int getQualifierLength() {
        return this.qualifierLength;
    }

    public byte[] getValueArray() {
        if (((ByteBuffer)this.pair.getFirst()).hasArray()) {
            return ((ByteBuffer)this.pair.getFirst()).array();
        }
        byte[] val = new byte[this.valueLength];
        ByteBufferUtils.copyFromBufferToArray((byte[])val, (ByteBuffer)((ByteBuffer)this.pair.getFirst()), (int)this.pair.getSecond(), (int)0, (int)this.valueLength);
        return val;
    }

    public int getValueOffset() {
        if (((ByteBuffer)this.pair.getFirst()).hasArray()) {
            return this.pair.getSecond() + ((ByteBuffer)this.pair.getFirst()).arrayOffset();
        }
        return 0;
    }

    public byte getTypeByte() {
        return this.type.getCode();
    }

    protected String getKeyValueString() {
        KeyValue kv = KeyValueUtil.copyToNewKeyValue((Cell)this);
        return kv.toString();
    }

    public int getTagsOffset() {
        return this.tagsOffset;
    }

    public int getTagsLength() {
        return this.tagsLength;
    }

    public byte[] getTagsArray() {
        return this.tagsBuffer;
    }

    public void setSequenceId(long seqId) {
        this.mvccVersion = seqId;
    }

    public ByteBuffer getRowByteBuffer() {
        return ByteBuffer.wrap(this.rowBuffer);
    }

    public int getRowPosition() {
        return 0;
    }

    public ByteBuffer getFamilyByteBuffer() {
        return ByteBuffer.wrap(this.familyBuffer);
    }

    public int getFamilyPosition() {
        return this.getFamilyOffset();
    }

    public ByteBuffer getQualifierByteBuffer() {
        return ByteBuffer.wrap(this.qualifierBuffer);
    }

    public int getQualifierPosition() {
        return this.getQualifierOffset();
    }

    public ByteBuffer getValueByteBuffer() {
        return (ByteBuffer)this.pair.getFirst();
    }

    public int getValuePosition() {
        return this.pair.getSecond();
    }

    public ByteBuffer getTagsByteBuffer() {
        return ByteBuffer.wrap(this.tagsBuffer);
    }

    public int getTagsPosition() {
        return this.getTagsOffset();
    }

    static {
        KeyValue.Type[] typeArray = KeyValue.Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            KeyValue.Type type;
            PrefixTreeCell.TYPES[type.getCode() & 0xFF] = type = typeArray[i];
        }
        DEFAULT_TYPE = KeyValue.Type.Put;
    }
}

