/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode.column;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.ColumnNodeType;
import org.apache.hadoop.hbase.util.vint.UFIntTool;
import org.apache.hadoop.hbase.util.vint.UVIntTool;

@InterfaceAudience.Private
public class ColumnNodeReader {
    protected PrefixTreeBlockMeta blockMeta;
    protected byte[] block;
    protected ColumnNodeType nodeType;
    protected byte[] columnBuffer;
    protected int offsetIntoBlock;
    protected int tokenOffsetIntoBlock;
    protected int tokenLength;
    protected int parentStartPosition;

    public ColumnNodeReader(byte[] columnBuffer, ColumnNodeType nodeType) {
        this.columnBuffer = columnBuffer;
        this.nodeType = nodeType;
    }

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, byte[] block) {
        this.blockMeta = blockMeta;
        this.block = block;
    }

    public void positionAt(int offsetIntoBlock) {
        this.offsetIntoBlock = offsetIntoBlock;
        this.tokenLength = UVIntTool.getInt(this.block, offsetIntoBlock);
        this.tokenOffsetIntoBlock = offsetIntoBlock + UVIntTool.numBytes(this.tokenLength);
        int parentStartPositionIndex = this.tokenOffsetIntoBlock + this.tokenLength;
        int offsetWidth = this.nodeType == ColumnNodeType.FAMILY ? this.blockMeta.getFamilyOffsetWidth() : (this.nodeType == ColumnNodeType.QUALIFIER ? this.blockMeta.getQualifierOffsetWidth() : this.blockMeta.getTagsOffsetWidth());
        this.parentStartPosition = (int)UFIntTool.fromBytes(this.block, parentStartPositionIndex, offsetWidth);
    }

    public void prependTokenToBuffer(int bufferStartIndex) {
        System.arraycopy(this.block, this.tokenOffsetIntoBlock, this.columnBuffer, bufferStartIndex, this.tokenLength);
    }

    public boolean isRoot() {
        if (this.nodeType == ColumnNodeType.FAMILY) {
            return this.offsetIntoBlock == this.blockMeta.getAbsoluteFamilyOffset();
        }
        if (this.nodeType == ColumnNodeType.QUALIFIER) {
            return this.offsetIntoBlock == this.blockMeta.getAbsoluteQualifierOffset();
        }
        return this.offsetIntoBlock == this.blockMeta.getAbsoluteTagsOffset();
    }

    public String toString() {
        return super.toString() + "[" + this.offsetIntoBlock + "]";
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public int getParentStartPosition() {
        return this.parentStartPosition;
    }
}

