/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.MultiTableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class MultiTableSnapshotInputFormat
extends TableSnapshotInputFormat
implements InputFormat<ImmutableBytesWritable, Result> {
    private final MultiTableSnapshotInputFormatImpl delegate = new MultiTableSnapshotInputFormatImpl();

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        List<TableSnapshotInputFormatImpl.InputSplit> splits = this.delegate.getSplits((Configuration)job);
        InputSplit[] results = new InputSplit[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            results[i] = new TableSnapshotInputFormat.TableSnapshotRegionSplit(splits.get(i));
        }
        return results;
    }

    @Override
    public RecordReader<ImmutableBytesWritable, Result> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new TableSnapshotInputFormat.TableSnapshotRecordReader((TableSnapshotInputFormat.TableSnapshotRegionSplit)split, job);
    }

    public static void setInput(Configuration conf, Map<String, Collection<Scan>> snapshotScans, Path restoreDir) throws IOException {
        new MultiTableSnapshotInputFormatImpl().setInput(conf, snapshotScans, restoreDir);
    }
}

