/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NoCacheFilter
implements Filter {
    public static final String NO_STORE = "no-store.enable";
    private boolean noStoreEnabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.noStoreEnabled = Boolean.valueOf(filterConfig.getInitParameter(NO_STORE));
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpRes = (HttpServletResponse)res;
        StringBuilder header = new StringBuilder("no-cache");
        if (this.noStoreEnabled) {
            header.append(", no-store, max-age=0");
        }
        httpRes.setHeader("Cache-Control", header.toString());
        long now = EnvironmentEdgeManager.currentTime();
        httpRes.addDateHeader("Expires", now);
        httpRes.addDateHeader("Date", now);
        httpRes.addHeader("Pragma", "no-cache");
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

