/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.util.ProcessUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProfileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProfileServlet.class);
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ALLOWED_METHODS = "GET";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";
    private static final String ASYNC_PROFILER_HOME_ENV = "ASYNC_PROFILER_HOME";
    private static final String ASYNC_PROFILER_HOME_SYSTEM_PROPERTY = "async.profiler.home";
    private static final String PROFILER_SCRIPT = "/profiler.sh";
    private static final int DEFAULT_DURATION_SECONDS = 10;
    private static final AtomicInteger ID_GEN = new AtomicInteger(0);
    static final String OUTPUT_DIR = System.getProperty("java.io.tmpdir") + "/prof-output";
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="This class is never serialized nor restored.")
    private transient Lock profilerLock = new ReentrantLock();
    private volatile transient Process process;
    private String asyncProfilerHome = ProfileServlet.getAsyncProfilerHome();
    private Integer pid = ProcessUtils.getPid();

    public ProfileServlet() {
        LOG.info("Servlet process PID: " + this.pid + " asyncProfilerHome: " + this.asyncProfilerHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block20: {
            if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), req, resp)) {
                resp.setStatus(401);
                ProfileServlet.setResponseHeader(resp);
                resp.getWriter().write("Unauthorized: Instrumentation access is not allowed!");
                return;
            }
            if (this.asyncProfilerHome == null || this.asyncProfilerHome.trim().isEmpty()) {
                resp.setStatus(500);
                ProfileServlet.setResponseHeader(resp);
                resp.getWriter().write("ASYNC_PROFILER_HOME env is not set.\n\nPlease ensure the prerequsites for the Profiler Servlet have been installed and the\nenvironment is properly configured. For more information please see\nhttp://hbase.apache.org/book.html#profiler\n");
                return;
            }
            this.pid = this.getInteger(req, "pid", this.pid);
            if (this.pid == null) {
                resp.setStatus(500);
                ProfileServlet.setResponseHeader(resp);
                resp.getWriter().write("'pid' query parameter unspecified or unable to determine PID of current process.");
                return;
            }
            int duration = this.getInteger(req, "duration", 10);
            Output output = this.getOutput(req);
            Event event = this.getEvent(req);
            Long interval = this.getLong(req, "interval");
            Integer jstackDepth = this.getInteger(req, "jstackdepth", null);
            Long bufsize = this.getLong(req, "bufsize");
            boolean thread = req.getParameterMap().containsKey("thread");
            boolean simple = req.getParameterMap().containsKey("simple");
            Integer width = this.getInteger(req, "width", null);
            Integer height = this.getInteger(req, "height", null);
            Double minwidth = this.getMinWidth(req);
            boolean reverse = req.getParameterMap().containsKey("reverse");
            if (this.process == null || !this.process.isAlive()) {
                try {
                    int lockTimeoutSecs = 3;
                    if (this.profilerLock.tryLock(lockTimeoutSecs, TimeUnit.SECONDS)) {
                        try {
                            File outputFile = new File(OUTPUT_DIR, "async-prof-pid-" + this.pid + "-" + event.name().toLowerCase() + "-" + ID_GEN.incrementAndGet() + "." + output.name().toLowerCase());
                            ArrayList<String> cmd = new ArrayList<String>();
                            cmd.add(this.asyncProfilerHome + PROFILER_SCRIPT);
                            cmd.add("-e");
                            cmd.add(event.getInternalName());
                            cmd.add("-d");
                            cmd.add("" + duration);
                            cmd.add("-o");
                            cmd.add(output.name().toLowerCase());
                            cmd.add("-f");
                            cmd.add(outputFile.getAbsolutePath());
                            if (interval != null) {
                                cmd.add("-i");
                                cmd.add(interval.toString());
                            }
                            if (jstackDepth != null) {
                                cmd.add("-j");
                                cmd.add(jstackDepth.toString());
                            }
                            if (bufsize != null) {
                                cmd.add("-b");
                                cmd.add(bufsize.toString());
                            }
                            if (thread) {
                                cmd.add("-t");
                            }
                            if (simple) {
                                cmd.add("-s");
                            }
                            if (width != null) {
                                cmd.add("--width");
                                cmd.add(width.toString());
                            }
                            if (height != null) {
                                cmd.add("--height");
                                cmd.add(height.toString());
                            }
                            if (minwidth != null) {
                                cmd.add("--minwidth");
                                cmd.add(minwidth.toString());
                            }
                            if (reverse) {
                                cmd.add("--reverse");
                            }
                            cmd.add(this.pid.toString());
                            this.process = ProcessUtils.runCmdAsync(cmd);
                            ProfileServlet.setResponseHeader(resp);
                            resp.setStatus(202);
                            String relativeUrl = "/prof-output/" + outputFile.getName();
                            resp.getWriter().write("Started [" + event.getInternalName() + "] profiling. This page will automatically redirect to " + relativeUrl + " after " + duration + " seconds.\n\nCommand:\n" + Joiner.on((String)" ").join(cmd));
                            int refreshDelay = this.getInteger(req, "refreshDelay", 0);
                            resp.setHeader("Refresh", duration + refreshDelay + ";" + relativeUrl);
                            resp.getWriter().flush();
                            break block20;
                        }
                        finally {
                            this.profilerLock.unlock();
                        }
                    }
                    ProfileServlet.setResponseHeader(resp);
                    resp.setStatus(500);
                    resp.getWriter().write("Unable to acquire lock. Another instance of profiler might be running.");
                    LOG.warn("Unable to acquire lock in " + lockTimeoutSecs + " seconds. Another instance of profiler might be running.");
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while acquiring profile lock.", (Throwable)e);
                    resp.setStatus(500);
                }
            } else {
                ProfileServlet.setResponseHeader(resp);
                resp.setStatus(500);
                resp.getWriter().write("Another instance of profiler is already running.");
            }
        }
    }

    private Integer getInteger(HttpServletRequest req, String param, Integer defaultValue) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private Long getLong(HttpServletRequest req, String param) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private Double getMinWidth(HttpServletRequest req) {
        String value = req.getParameter("minwidth");
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private Event getEvent(HttpServletRequest req) {
        String eventArg = req.getParameter("event");
        if (eventArg != null) {
            Event event = Event.fromInternalName(eventArg);
            return event == null ? Event.CPU : event;
        }
        return Event.CPU;
    }

    private Output getOutput(HttpServletRequest req) {
        String outputArg = req.getParameter("output");
        if (req.getParameter("output") != null) {
            try {
                return Output.valueOf(outputArg.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Output.SVG;
            }
        }
        return Output.SVG;
    }

    static void setResponseHeader(HttpServletResponse response) {
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, ALLOWED_METHODS);
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setContentType(CONTENT_TYPE_TEXT);
    }

    static String getAsyncProfilerHome() {
        String asyncProfilerHome = System.getenv(ASYNC_PROFILER_HOME_ENV);
        if (asyncProfilerHome == null || asyncProfilerHome.trim().isEmpty()) {
            asyncProfilerHome = System.getProperty(ASYNC_PROFILER_HOME_SYSTEM_PROPERTY);
        }
        return asyncProfilerHome;
    }

    public static class DisabledServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.setStatus(500);
            ProfileServlet.setResponseHeader(resp);
            resp.getWriter().write("The profiler servlet was disabled at startup.\n\nPlease ensure the prerequsites for the Profiler Servlet have been installed and the\nenvironment is properly configured. For more information please see\nhttp://hbase.apache.org/book.html#profiler\n");
        }
    }

    static enum Output {
        SUMMARY,
        TRACES,
        FLAT,
        COLLAPSED,
        SVG,
        TREE,
        JFR;

    }

    static enum Event {
        CPU("cpu"),
        ALLOC("alloc"),
        LOCK("lock"),
        PAGE_FAULTS("page-faults"),
        CONTEXT_SWITCHES("context-switches"),
        CYCLES("cycles"),
        INSTRUCTIONS("instructions"),
        CACHE_REFERENCES("cache-references"),
        CACHE_MISSES("cache-misses"),
        BRANCHES("branches"),
        BRANCH_MISSES("branch-misses"),
        BUS_CYCLES("bus-cycles"),
        L1_DCACHE_LOAD_MISSES("L1-dcache-load-misses"),
        LLC_LOAD_MISSES("LLC-load-misses"),
        DTLB_LOAD_MISSES("dTLB-load-misses"),
        MEM_BREAKPOINT("mem:breakpoint"),
        TRACE_TRACEPOINT("trace:tracepoint");

        private final String internalName;

        private Event(String internalName) {
            this.internalName = internalName;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public static Event fromInternalName(String name) {
            for (Event event : Event.values()) {
                if (!event.getInternalName().equalsIgnoreCase(name)) continue;
                return event;
            }
            return null;
        }
    }
}

