/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AdminAuthorizedFilter
implements Filter {
    private Configuration conf;
    private AccessControlList adminsAcl;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.adminsAcl = (AccessControlList)filterConfig.getServletContext().getAttribute("admins.acl");
        this.conf = (Configuration)filterConfig.getServletContext().getAttribute("hbase.conf");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new UnsupportedOperationException("Only accepts HTTP");
        }
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        if (!HttpServer.hasAdministratorAccess(this.conf, this.adminsAcl, httpReq, httpResp)) {
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

