/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public class MetricsRegionSourceImpl
implements MetricsRegionSource {
    private final MetricsRegionWrapper regionWrapper;
    private boolean closed = false;
    private MetricsRegionAggregateSourceImpl agg;
    private DynamicMetricsRegistry registry;
    private static final Log LOG = LogFactory.getLog(MetricsRegionSourceImpl.class);
    private String regionNamePrefix;
    private String regionPutKey;
    private String regionDeleteKey;
    private String regionGetKey;
    private String regionIncrementKey;
    private String regionAppendKey;
    private String regionScanNextKey;
    private MutableCounterLong regionPut;
    private MutableCounterLong regionDelete;
    private MutableCounterLong regionIncrement;
    private MutableCounterLong regionAppend;
    private MutableHistogram regionGet;
    private MutableHistogram regionScanNext;

    public MetricsRegionSourceImpl(MetricsRegionWrapper regionWrapper, MetricsRegionAggregateSourceImpl aggregate) {
        this.regionWrapper = regionWrapper;
        this.agg = aggregate;
        this.agg.register(this);
        LOG.debug((Object)("Creating new MetricsRegionSourceImpl for table " + regionWrapper.getTableName() + " " + regionWrapper.getRegionName()));
        this.registry = this.agg.getMetricsRegistry();
        this.regionNamePrefix = "namespace_" + regionWrapper.getNamespace() + "_table_" + regionWrapper.getTableName() + "_region_" + regionWrapper.getRegionName() + "_metric_";
        String suffix = "Count";
        this.regionPutKey = this.regionNamePrefix + "mutate" + suffix;
        this.regionPut = this.registry.getLongCounter(this.regionPutKey, 0L);
        this.regionDeleteKey = this.regionNamePrefix + "delete" + suffix;
        this.regionDelete = this.registry.getLongCounter(this.regionDeleteKey, 0L);
        this.regionIncrementKey = this.regionNamePrefix + "increment" + suffix;
        this.regionIncrement = this.registry.getLongCounter(this.regionIncrementKey, 0L);
        this.regionAppendKey = this.regionNamePrefix + "append" + suffix;
        this.regionAppend = this.registry.getLongCounter(this.regionAppendKey, 0L);
        this.regionGetKey = this.regionNamePrefix + "get";
        this.regionGet = this.registry.newHistogram(this.regionGetKey);
        this.regionScanNextKey = this.regionNamePrefix + "scanNext";
        this.regionScanNext = this.registry.newHistogram(this.regionScanNextKey);
    }

    public void close() {
        this.closed = true;
        this.agg.deregister(this);
        LOG.trace((Object)("Removing region Metrics: " + this.regionWrapper.getRegionName()));
        this.registry.removeMetric(this.regionPutKey);
        this.registry.removeMetric(this.regionDeleteKey);
        this.registry.removeMetric(this.regionIncrementKey);
        this.registry.removeMetric(this.regionAppendKey);
        this.registry.removeMetric(this.regionGetKey);
        this.registry.removeMetric(this.regionScanNextKey);
        JmxCacheBuster.clearJmxCache();
    }

    public void updatePut() {
        this.regionPut.incr();
    }

    public void updateDelete() {
        this.regionDelete.incr();
    }

    public void updateGet(long getSize) {
        this.regionGet.add(getSize);
    }

    public void updateScan(long scanSize) {
        this.regionScanNext.add(scanSize);
    }

    public void updateIncrement() {
        this.regionIncrement.incr();
    }

    public void updateAppend() {
        this.regionAppend.incr();
    }

    public MetricsRegionAggregateSource getAggregateSource() {
        return this.agg;
    }

    public int compareTo(MetricsRegionSource source) {
        if (!(source instanceof MetricsRegionSourceImpl)) {
            return -1;
        }
        MetricsRegionSourceImpl impl = (MetricsRegionSourceImpl)source;
        return this.regionWrapper.getRegionName().compareTo(impl.regionWrapper.getRegionName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetricsRegionSourceImpl)) {
            return false;
        }
        return this.compareTo((MetricsRegionSourceImpl)obj) == 0;
    }

    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed) {
            return;
        }
        mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "storeCount"), (String)"Number of Stores"), this.regionWrapper.getNumStores());
        mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "storeFileCount"), (String)"Number of Store Files"), this.regionWrapper.getNumStoreFiles());
        mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "memStoreSize"), (String)"Size of the memstore"), this.regionWrapper.getMemstoreSize());
        mrb.addGauge(Interns.info((String)(this.regionNamePrefix + "storeFileSize"), (String)"Size of storefiles being served."), this.regionWrapper.getStoreFileSize());
        mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "compactionsCompletedCount"), (String)"Number of compactions that have completed."), this.regionWrapper.getNumCompactionsCompleted());
        mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "numBytesCompactedCount"), (String)"Sum of filesize on all files entering a finished, successful or aborted, compaction"), this.regionWrapper.getNumBytesCompacted());
        mrb.addCounter(Interns.info((String)(this.regionNamePrefix + "numFilesCompactedCount"), (String)"Number of files that were input for finished, successful or aborted, compactions"), this.regionWrapper.getNumFilesCompacted());
        for (Map.Entry entry : this.regionWrapper.getCoprocessorExecutionStatistics().entrySet()) {
            DescriptiveStatistics ds = (DescriptiveStatistics)entry.getValue();
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + " " + (String)entry.getKey() + " " + "coprocessorExecutionStatistics"), (String)"Statistics for coprocessor execution timesMin: "), ds.getMin() / 1000.0);
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + " " + (String)entry.getKey() + " " + "coprocessorExecutionStatistics"), (String)"Statistics for coprocessor execution timesMean: "), ds.getMean() / 1000.0);
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + " " + (String)entry.getKey() + " " + "coprocessorExecutionStatistics"), (String)"Statistics for coprocessor execution timesMax: "), ds.getMax() / 1000.0);
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + " " + (String)entry.getKey() + " " + "coprocessorExecutionStatistics"), (String)"Statistics for coprocessor execution times90th percentile: "), ds.getPercentile(90.0) / 1000.0);
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + " " + (String)entry.getKey() + " " + "coprocessorExecutionStatistics"), (String)"Statistics for coprocessor execution times95th percentile: "), ds.getPercentile(95.0) / 1000.0);
            mrb.addGauge(Interns.info((String)(this.regionNamePrefix + " " + (String)entry.getKey() + " " + "coprocessorExecutionStatistics"), (String)"Statistics for coprocessor execution times99th percentile: "), ds.getPercentile(99.0) / 1000.0);
        }
    }
}

