/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.master.MetricsSnapshotSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;

public class MetricsSnapshotSourceImpl
extends BaseSourceImpl
implements MetricsSnapshotSource {
    private MetricMutableHistogram snapshotTimeHisto;
    private MetricMutableHistogram snapshotCloneTimeHisto;
    private MetricMutableHistogram snapshotRestoreTimeHisto;

    public MetricsSnapshotSourceImpl() {
        this("Snapshots", "Metrics about HBase master server", "master", "Master,sub=Snapshots");
    }

    public MetricsSnapshotSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.snapshotTimeHisto = this.metricsRegistry.newHistogram("snapshotTime", "Time it takes to finish snapshot()");
        this.snapshotCloneTimeHisto = this.metricsRegistry.newHistogram("snapshotCloneTime", "Time it takes to finish cloneSnapshot()");
        this.snapshotRestoreTimeHisto = this.metricsRegistry.newHistogram("snapshotRestoreTime", "Time it takes to finish restoreSnapshot()");
    }

    public void updateSnapshotTime(long time) {
        this.snapshotTimeHisto.add(time);
    }

    public void updateSnapshotCloneTime(long time) {
        this.snapshotCloneTimeHisto.add(time);
    }

    public void updateSnapshotRestoreTime(long time) {
        this.snapshotRestoreTimeHisto.add(time);
    }
}

