/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface CellComparator
extends Comparator<Cell> {
    public static CellComparator getInstance() {
        return CellComparatorImpl.COMPARATOR;
    }

    @Override
    public int compare(Cell var1, Cell var2);

    public int compare(Cell var1, Cell var2, boolean var3);

    public int compareRows(Cell var1, Cell var2);

    public int compareRows(Cell var1, byte[] var2, int var3, int var4);

    default public int compareRows(byte[] leftRow, byte[] rightRow) {
        return Bytes.compareTo(leftRow, rightRow);
    }

    default public int compareRows(ByteBuffer row, Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(row, row.position(), row.remaining(), ((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), (int)cell.getRowLength());
        }
        return ByteBufferUtils.compareTo(row, row.position(), row.remaining(), cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
    }

    public int compareWithoutRow(Cell var1, Cell var2);

    public int compareFamilies(Cell var1, Cell var2);

    public int compareQualifiers(Cell var1, Cell var2);

    public int compareTimestamps(Cell var1, Cell var2);

    public int compareTimestamps(long var1, long var3);

    public Comparator getSimpleComparator();
}

