/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.net;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestAddress {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAddress.class);

    @Test
    public void testGetHostWithoutDomain() {
        Assert.assertEquals((Object)"a:123", (Object)Address.fromParts((String)"a.b.c", (int)123).toStringWithoutDomain());
        Assert.assertEquals((Object)"1:123", (Object)Address.fromParts((String)"1.b.c", (int)123).toStringWithoutDomain());
        Assert.assertEquals((Object)"123.456.789.1:123", (Object)Address.fromParts((String)"123.456.789.1", (int)123).toStringWithoutDomain());
        Assert.assertEquals((Object)"[2001:db8::1]:80", (Object)Address.fromParts((String)"[2001:db8::1]:", (int)80).toStringWithoutDomain());
        Assert.assertEquals((Object)"[2001:db8::1]:80", (Object)Address.fromParts((String)"[2001:db8::1]:", (int)80).toStringWithoutDomain());
    }
}

