/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NoTagsByteBufferKeyValue;
import org.apache.hadoop.hbase.NoTagsKeyValue;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class KeyValueCodec
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new KeyValueDecoder(is);
    }

    @Override
    public Codec.Decoder getDecoder(ByteBuff buf) {
        return new ByteBuffKeyValueDecoder(buf);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new KeyValueEncoder(os);
    }

    public static class ByteBuffKeyValueDecoder
    implements Codec.Decoder {
        protected final ByteBuff buf;
        protected Cell current = null;

        public ByteBuffKeyValueDecoder(ByteBuff buf) {
            this.buf = buf;
        }

        @Override
        public boolean advance() throws IOException {
            if (!this.buf.hasRemaining()) {
                return false;
            }
            int len = this.buf.getInt();
            ByteBuffer bb = this.buf.asSubByteBuffer(len);
            this.current = bb.isDirect() ? this.createCell(bb, bb.position(), len) : this.createCell(bb.array(), bb.arrayOffset() + bb.position(), len);
            this.buf.skip(len);
            return true;
        }

        @Override
        public Cell current() {
            return this.current;
        }

        protected Cell createCell(byte[] buf, int offset, int len) {
            return new NoTagsKeyValue(buf, offset, len);
        }

        protected Cell createCell(ByteBuffer bb, int pos, int len) {
            return new NoTagsByteBufferKeyValue(bb, pos, len);
        }
    }

    public static class KeyValueDecoder
    extends BaseDecoder {
        public KeyValueDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            return KeyValueUtil.iscreate(this.in, false);
        }
    }

    public static class KeyValueEncoder
    extends BaseEncoder {
        public KeyValueEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            ByteBufferUtils.putInt(this.out, KeyValueUtil.getSerializedSize(cell, false));
            KeyValueUtil.oswrite(cell, this.out, false);
        }
    }
}

