/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Base64;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestBase64
extends TestCase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBase64.class);
    private String[] uris = new String[]{"dns://dns.powerset.com/www.powerset.com", "dns:www.powerset.com", "file:///usr/bin/java", "filename", "ftp://one.two.three/index.html", "http://one.two.three/index.html", "https://one.two.three:9443/index.html", "r:dns://com.powerset.dns/www.powerset.com", "r:ftp://three.two.one/index.html", "r:http://three.two.one/index.html", "r:https://three.two.one:9443/index.html"};

    public void testBase64() throws UnsupportedEncodingException {
        int i;
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (i = 0; i < this.uris.length; ++i) {
            byte[] bytes = this.uris[i].getBytes("UTF-8");
            sorted.put(Base64.encodeBytes((byte[])bytes, (int)32), this.uris[i]);
        }
        System.out.println();
        i = 0;
        for (Map.Entry e : sorted.entrySet()) {
            TestBase64.assertTrue((this.uris[i++].compareTo((String)e.getValue()) == 0 ? 1 : 0) != 0);
        }
    }
}

