/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class VersionInfo {
    private static final Log LOG = LogFactory.getLog((String)VersionInfo.class.getName());
    private static int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return "1.4.14.700-eep-922";
    }

    public static String getRevision() {
        return "71b72fcb3ddb30c0c652e2274078512a7c8aab55";
    }

    public static String getDate() {
        return "Thu Apr  4 06:46:45 PDT 2024";
    }

    public static String getUser() {
        return "root";
    }

    public static String getUrl() {
        return "git://7f8400101ebc/data/jenkins/workspace/ase_branch-1.4.14-mapr-mep-9.2.2/mapr-hbase-1.4.14/dl/mapr-hbase-1.4.14";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "bab96008d58de18d6cf91377fc629a6f";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info((Object)line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        int index;
        if (v1.equals(v2)) {
            return 0;
        }
        String[] s1 = v1.split("\\.|-");
        String[] s2 = v2.split("\\.|-");
        for (index = 0; index < s1.length && index < s2.length; ++index) {
            int c;
            int va = VERY_LARGE_NUMBER;
            int vb = VERY_LARGE_NUMBER;
            try {
                va = Integer.parseInt(s1[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                vb = Integer.parseInt(s2[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (va != vb) {
                return va - vb;
            }
            if (va != VERY_LARGE_NUMBER || (c = s1[index].compareTo(s2[index])) == 0) continue;
            return c;
        }
        if (index < s1.length) {
            return 1;
        }
        return -1;
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

