/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.util.ByteBufferUtils;

@InterfaceAudience.Private
public class PrefixKeyDeltaEncoder
extends BufferedDataBlockEncoder {
    private int addKV(int prevKeyOffset, DataOutputStream out, ByteBuffer in, int prevKeyLength) throws IOException {
        int keyLength = in.getInt();
        int valueLength = in.getInt();
        if (prevKeyOffset == -1) {
            ByteBufferUtils.putCompressedInt(out, keyLength);
            ByteBufferUtils.putCompressedInt(out, valueLength);
            ByteBufferUtils.putCompressedInt(out, 0);
            ByteBufferUtils.moveBufferToStream(out, in, keyLength + valueLength);
        } else {
            int common = ByteBufferUtils.findCommonPrefix(in, prevKeyOffset + 8, in.position(), Math.min(prevKeyLength, keyLength));
            ByteBufferUtils.putCompressedInt(out, keyLength - common);
            ByteBufferUtils.putCompressedInt(out, valueLength);
            ByteBufferUtils.putCompressedInt(out, common);
            ByteBufferUtils.skip(in, common);
            ByteBufferUtils.moveBufferToStream(out, in, keyLength - common + valueLength);
        }
        return keyLength;
    }

    @Override
    public void internalEncodeKeyValues(DataOutputStream writeHere, ByteBuffer in, HFileBlockDefaultEncodingContext encodingCtx) throws IOException {
        in.rewind();
        ByteBufferUtils.putInt(writeHere, in.limit());
        int prevOffset = -1;
        int offset = 0;
        int keyLength = 0;
        while (in.hasRemaining()) {
            offset = in.position();
            keyLength = this.addKV(prevOffset, writeHere, in, keyLength);
            this.afterEncodingKeyValue(in, writeHere, encodingCtx);
            prevOffset = offset;
        }
    }

    @Override
    protected ByteBuffer internalDecodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        int decompressedSize = source.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + allocateHeaderLength);
        buffer.position(allocateHeaderLength);
        int prevKeyOffset = 0;
        while (source.available() > skipLastBytes) {
            prevKeyOffset = this.decodeKeyValue(source, buffer, prevKeyOffset);
            this.afterDecodingKeyValue(source, buffer, decodingCtx);
        }
        if (source.available() != skipLastBytes) {
            throw new IllegalStateException("Read too many bytes.");
        }
        buffer.limit(buffer.position());
        return buffer;
    }

    private int decodeKeyValue(DataInputStream source, ByteBuffer buffer, int prevKeyOffset) throws IOException, EncoderBufferTooSmallException {
        int keyOffset;
        int keyLength = ByteBufferUtils.readCompressedInt(source);
        int valueLength = ByteBufferUtils.readCompressedInt(source);
        int commonLength = ByteBufferUtils.readCompressedInt(source);
        PrefixKeyDeltaEncoder.ensureSpace(buffer, (keyLength += commonLength) + valueLength + 8);
        buffer.putInt(keyLength);
        buffer.putInt(valueLength);
        if (commonLength > 0) {
            keyOffset = buffer.position();
            ByteBufferUtils.copyFromBufferToBuffer(buffer, buffer, prevKeyOffset, commonLength);
        } else {
            keyOffset = buffer.position();
        }
        int len = keyLength - commonLength + valueLength;
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, len);
        return keyOffset;
    }

    @Override
    public ByteBuffer getFirstKeyInBlock(ByteBuffer block) {
        block.mark();
        block.position(4);
        int keyLength = ByteBufferUtils.readCompressedInt(block);
        ByteBufferUtils.readCompressedInt(block);
        int commonLength = ByteBufferUtils.readCompressedInt(block);
        if (commonLength != 0) {
            throw new AssertionError((Object)("Nonzero common length in the first key in block: " + commonLength));
        }
        int pos = block.position();
        block.reset();
        return ByteBuffer.wrap(block.array(), pos, keyLength).slice();
    }

    public String toString() {
        return PrefixKeyDeltaEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
        return new BufferedDataBlockEncoder.BufferedEncodedSeeker<BufferedDataBlockEncoder.SeekerState>(comparator, decodingCtx){

            @Override
            protected void decodeNext() {
                this.current.keyLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                this.current.valueLength = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                this.current.lastCommonPrefix = ByteBufferUtils.readCompressedInt(this.currentBuffer);
                this.current.keyLength += this.current.lastCommonPrefix;
                this.current.ensureSpaceForKey();
                this.currentBuffer.get(this.current.keyBuffer, this.current.lastCommonPrefix, this.current.keyLength - this.current.lastCommonPrefix);
                this.current.valueOffset = this.currentBuffer.position();
                ByteBufferUtils.skip(this.currentBuffer, this.current.valueLength);
                if (this.includesTags()) {
                    this.decodeTags();
                }
                this.current.memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
                this.current.nextKvOffset = this.currentBuffer.position();
            }

            @Override
            protected void decodeFirst() {
                ByteBufferUtils.skip(this.currentBuffer, 4);
                this.decodeNext();
            }
        };
    }
}

