/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ShadedAccessControlUtil {
    public static AccessControlProtos.Permission.Action toPermissionAction(Permission.Action action) {
        switch (action) {
            case READ: {
                return AccessControlProtos.Permission.Action.READ;
            }
            case WRITE: {
                return AccessControlProtos.Permission.Action.WRITE;
            }
            case EXEC: {
                return AccessControlProtos.Permission.Action.EXEC;
            }
            case CREATE: {
                return AccessControlProtos.Permission.Action.CREATE;
            }
            case ADMIN: {
                return AccessControlProtos.Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static Permission.Action toPermissionAction(AccessControlProtos.Permission.Action action) {
        switch (action) {
            case READ: {
                return Permission.Action.READ;
            }
            case WRITE: {
                return Permission.Action.WRITE;
            }
            case EXEC: {
                return Permission.Action.EXEC;
            }
            case CREATE: {
                return Permission.Action.CREATE;
            }
            case ADMIN: {
                return Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static Permission.Action[] toPermissionActions(List<AccessControlProtos.Permission.Action> protoActions) {
        Permission.Action[] actions = new Permission.Action[protoActions.size()];
        for (int i = 0; i < protoActions.size(); ++i) {
            actions[i] = ShadedAccessControlUtil.toPermissionAction(protoActions.get(i));
        }
        return actions;
    }

    public static TableName toTableName(HBaseProtos.TableName tableNamePB) {
        return TableName.valueOf((ByteBuffer)tableNamePB.getNamespace().asReadOnlyByteBuffer(), (ByteBuffer)tableNamePB.getQualifier().asReadOnlyByteBuffer());
    }

    public static HBaseProtos.TableName toProtoTableName(TableName tableName) {
        return HBaseProtos.TableName.newBuilder().setNamespace(ByteString.copyFrom((byte[])tableName.getNamespace())).setQualifier(ByteString.copyFrom((byte[])tableName.getQualifier())).build();
    }

    public static Permission toPermission(AccessControlProtos.Permission proto) {
        if (proto.getType() == AccessControlProtos.Permission.Type.Global) {
            AccessControlProtos.GlobalPermission perm = proto.getGlobalPermission();
            Permission.Action[] actions = ShadedAccessControlUtil.toPermissionActions(perm.getActionList());
            return Permission.newBuilder().withActions(actions).build();
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Namespace) {
            AccessControlProtos.NamespacePermission perm = proto.getNamespacePermission();
            Permission.Action[] actions = ShadedAccessControlUtil.toPermissionActions(perm.getActionList());
            if (!proto.hasNamespacePermission()) {
                throw new IllegalStateException("Namespace must not be empty in NamespacePermission");
            }
            String ns = perm.getNamespaceName().toStringUtf8();
            return Permission.newBuilder(ns).withActions(actions).build();
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Table) {
            AccessControlProtos.TablePermission perm = proto.getTablePermission();
            Permission.Action[] actions = ShadedAccessControlUtil.toPermissionActions(perm.getActionList());
            byte[] qualifier = null;
            byte[] family = null;
            if (!perm.hasTableName()) {
                throw new IllegalStateException("TableName cannot be empty");
            }
            TableName table = ShadedAccessControlUtil.toTableName(perm.getTableName());
            if (perm.hasFamily()) {
                family = perm.getFamily().toByteArray();
            }
            if (perm.hasQualifier()) {
                qualifier = perm.getQualifier().toByteArray();
            }
            return Permission.newBuilder(table).withFamily(family).withQualifier(qualifier).withActions(actions).build();
        }
        throw new IllegalStateException("Unrecognize Perm Type: " + proto.getType());
    }

    public static AccessControlProtos.Permission toPermission(Permission perm) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        if (perm instanceof NamespacePermission) {
            NamespacePermission nsPerm = (NamespacePermission)perm;
            ret.setType(AccessControlProtos.Permission.Type.Namespace);
            AccessControlProtos.NamespacePermission.Builder builder = AccessControlProtos.NamespacePermission.newBuilder();
            builder.setNamespaceName(ByteString.copyFromUtf8((String)nsPerm.getNamespace()));
            Permission.Action[] actions = perm.getActions();
            if (actions != null) {
                for (Permission.Action a : actions) {
                    builder.addAction(ShadedAccessControlUtil.toPermissionAction(a));
                }
            }
            ret.setNamespacePermission(builder);
        } else if (perm instanceof TablePermission) {
            Permission.Action[] actions;
            TablePermission tablePerm = (TablePermission)perm;
            ret.setType(AccessControlProtos.Permission.Type.Table);
            AccessControlProtos.TablePermission.Builder builder = AccessControlProtos.TablePermission.newBuilder();
            builder.setTableName(ShadedAccessControlUtil.toProtoTableName(tablePerm.getTableName()));
            if (tablePerm.hasFamily()) {
                builder.setFamily(ByteString.copyFrom((byte[])tablePerm.getFamily()));
            }
            if (tablePerm.hasQualifier()) {
                builder.setQualifier(ByteString.copyFrom((byte[])tablePerm.getQualifier()));
            }
            if ((actions = perm.getActions()) != null) {
                for (Permission.Action a : actions) {
                    builder.addAction(ShadedAccessControlUtil.toPermissionAction(a));
                }
            }
            ret.setTablePermission(builder);
        } else {
            ret.setType(AccessControlProtos.Permission.Type.Global);
            AccessControlProtos.GlobalPermission.Builder builder = AccessControlProtos.GlobalPermission.newBuilder();
            Permission.Action[] actions = perm.getActions();
            if (actions != null) {
                for (Permission.Action a : actions) {
                    builder.addAction(ShadedAccessControlUtil.toPermissionAction(a));
                }
            }
            ret.setGlobalPermission(builder);
        }
        return ret.build();
    }

    public static ListMultimap<String, Permission> toUserTablePermissions(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap perms = ArrayListMultimap.create();
        for (int i = 0; i < proto.getUserPermissionsCount(); ++i) {
            AccessControlProtos.UsersAndPermissions.UserPermissions userPerm = proto.getUserPermissions(i);
            for (int j = 0; j < userPerm.getPermissionsCount(); ++j) {
                Permission perm = ShadedAccessControlUtil.toPermission(userPerm.getPermissions(j));
                perms.put((Object)userPerm.getUser().toStringUtf8(), (Object)perm);
            }
        }
        return perms;
    }

    public static AccessControlProtos.UsersAndPermissions toUserTablePermissions(ListMultimap<String, UserPermission> perm) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry entry : perm.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8((String)((String)entry.getKey())));
            for (UserPermission userPerm : (Collection)entry.getValue()) {
                userPermBuilder.addPermissions(ShadedAccessControlUtil.toPermission(userPerm.getPermission()));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }

    public static UserPermission toUserPermission(AccessControlProtos.UserPermission proto) {
        return new UserPermission(proto.getUser().toStringUtf8(), ShadedAccessControlUtil.toPermission(proto.getPermission()));
    }

    public static AccessControlProtos.UserPermission toUserPermission(UserPermission perm) {
        return AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)perm.getUser())).setPermission(ShadedAccessControlUtil.toPermission(perm.getPermission())).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(UserPermission userPermission, boolean mergeExistingPermissions) {
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(ShadedAccessControlUtil.toUserPermission(userPermission)).setMergeExistingPermissions(mergeExistingPermissions).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(UserPermission userPermission) {
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(ShadedAccessControlUtil.toUserPermission(userPermission)).build();
    }

    public static AccessControlProtos.GetUserPermissionsRequest buildGetUserPermissionsRequest(GetUserPermissionsRequest request) {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        if (request.getUserName() != null && !request.getUserName().isEmpty()) {
            builder.setUserName(ByteString.copyFromUtf8((String)request.getUserName()));
        }
        if (request.getNamespace() != null && !request.getNamespace().isEmpty()) {
            builder.setNamespaceName(ByteString.copyFromUtf8((String)request.getNamespace()));
            builder.setType(AccessControlProtos.Permission.Type.Namespace);
        }
        if (request.getTableName() != null) {
            builder.setTableName(ShadedAccessControlUtil.toProtoTableName(request.getTableName()));
            builder.setType(AccessControlProtos.Permission.Type.Table);
        }
        if (!builder.hasType()) {
            builder.setType(AccessControlProtos.Permission.Type.Global);
        }
        if (request.getFamily() != null && request.getFamily().length > 0) {
            builder.setColumnFamily(ByteString.copyFrom((byte[])request.getFamily()));
        }
        if (request.getQualifier() != null && request.getQualifier().length > 0) {
            builder.setColumnQualifier(ByteString.copyFrom((byte[])request.getQualifier()));
        }
        return builder.build();
    }

    public static AccessControlProtos.GetUserPermissionsResponse buildGetUserPermissionsResponse(List<UserPermission> permissions) {
        AccessControlProtos.GetUserPermissionsResponse.Builder builder = AccessControlProtos.GetUserPermissionsResponse.newBuilder();
        for (UserPermission perm : permissions) {
            builder.addUserPermission(ShadedAccessControlUtil.toUserPermission(perm));
        }
        return builder.build();
    }

    public static AccessControlProtos.HasUserPermissionsRequest buildHasUserPermissionsRequest(String userName, List<Permission> permissions) {
        AccessControlProtos.HasUserPermissionsRequest.Builder builder = AccessControlProtos.HasUserPermissionsRequest.newBuilder();
        if (userName != null && !userName.isEmpty()) {
            builder.setUserName(ByteString.copyFromUtf8((String)userName));
        }
        for (Permission permission : permissions) {
            builder.addPermission(ShadedAccessControlUtil.toPermission(permission));
        }
        return builder.build();
    }
}

