/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncConnection
extends Closeable {
    public Configuration getConfiguration();

    public AsyncTableRegionLocator getRegionLocator(TableName var1);

    default public AsyncTable<AdvancedScanResultConsumer> getTable(TableName tableName) {
        return this.getTableBuilder(tableName).build();
    }

    public AsyncTableBuilder<AdvancedScanResultConsumer> getTableBuilder(TableName var1);

    default public AsyncTable<ScanResultConsumer> getTable(TableName tableName, ExecutorService pool) {
        return this.getTableBuilder(tableName, pool).build();
    }

    public AsyncTableBuilder<ScanResultConsumer> getTableBuilder(TableName var1, ExecutorService var2);

    default public AsyncAdmin getAdmin() {
        return this.getAdminBuilder().build();
    }

    public AsyncAdminBuilder getAdminBuilder();

    default public AsyncAdmin getAdmin(ExecutorService pool) {
        return this.getAdminBuilder(pool).build();
    }

    public AsyncAdminBuilder getAdminBuilder(ExecutorService var1);

    default public AsyncBufferedMutator getBufferedMutator(TableName tableName) {
        return this.getBufferedMutatorBuilder(tableName).build();
    }

    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName var1);

    default public AsyncBufferedMutator getBufferedMutator(TableName tableName, ExecutorService pool) {
        return this.getBufferedMutatorBuilder(tableName, pool).build();
    }

    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName var1, ExecutorService var2);
}

