/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdminRequestRetryingCaller;
import org.apache.hadoop.hbase.client.AsyncBatchRpcRetryingCaller;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncMasterRequestRpcRetryingCaller;
import org.apache.hadoop.hbase.client.AsyncScanSingleRegionRpcRetryingCaller;
import org.apache.hadoop.hbase.client.AsyncServerRequestRpcRetryingCaller;
import org.apache.hadoop.hbase.client.AsyncSingleRequestRpcRetryingCaller;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RawScanResultConsumer;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncRpcRetryingCallerFactory {
    private final AsyncConnectionImpl conn;
    private final HashedWheelTimer retryTimer;

    public AsyncRpcRetryingCallerFactory(AsyncConnectionImpl conn, HashedWheelTimer retryTimer) {
        this.conn = conn;
        this.retryTimer = retryTimer;
    }

    public <T> SingleRequestCallerBuilder<T> single() {
        return new SingleRequestCallerBuilder();
    }

    public ScanSingleRegionCallerBuilder scanSingleRegion() {
        return new ScanSingleRegionCallerBuilder();
    }

    public BatchCallerBuilder batch() {
        return new BatchCallerBuilder();
    }

    public <T> MasterRequestCallerBuilder<T> masterRequest() {
        return new MasterRequestCallerBuilder();
    }

    public <T> AdminRequestCallerBuilder<T> adminRequest() {
        return new AdminRequestCallerBuilder();
    }

    public <T> ServerRequestCallerBuilder<T> serverRequest() {
        return new ServerRequestCallerBuilder();
    }

    public class ServerRequestCallerBuilder<T>
    extends BuilderBase {
        private AsyncServerRequestRpcRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;
        private ServerName serverName;

        public ServerRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
        }

        public ServerRequestCallerBuilder<T> action(AsyncServerRequestRpcRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public ServerRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public ServerRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public ServerRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public ServerRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public ServerRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public ServerRequestCallerBuilder<T> serverName(ServerName serverName) {
            this.serverName = serverName;
            return this;
        }

        public AsyncServerRequestRpcRetryingCaller<T> build() {
            return new AsyncServerRequestRpcRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.pauseNs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt, this.serverName, (AsyncServerRequestRpcRetryingCaller.Callable)Preconditions.checkNotNull(this.callable, (Object)"action is null"));
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    public class AdminRequestCallerBuilder<T>
    extends BuilderBase {
        private AsyncAdminRequestRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;
        private ServerName serverName;

        public AdminRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
        }

        public AdminRequestCallerBuilder<T> action(AsyncAdminRequestRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public AdminRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public AdminRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public AdminRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public AdminRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public AdminRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public AdminRequestCallerBuilder<T> serverName(ServerName serverName) {
            this.serverName = serverName;
            return this;
        }

        public AsyncAdminRequestRetryingCaller<T> build() {
            return new AsyncAdminRequestRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.pauseNs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt, this.serverName, (AsyncAdminRequestRetryingCaller.Callable)Preconditions.checkNotNull(this.callable, (Object)"action is null"));
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    public class MasterRequestCallerBuilder<T>
    extends BuilderBase {
        private AsyncMasterRequestRpcRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;

        public MasterRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
        }

        public MasterRequestCallerBuilder<T> action(AsyncMasterRequestRpcRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public MasterRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public MasterRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public MasterRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public MasterRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public MasterRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public AsyncMasterRequestRpcRetryingCaller<T> build() {
            return new AsyncMasterRequestRpcRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, (AsyncMasterRequestRpcRetryingCaller.Callable)Preconditions.checkNotNull(this.callable, (Object)"action is null"), this.pauseNs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    public class BatchCallerBuilder
    extends BuilderBase {
        private TableName tableName;
        private List<? extends Row> actions;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;

        public BatchCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
        }

        public BatchCallerBuilder table(TableName tableName) {
            this.tableName = tableName;
            return this;
        }

        public BatchCallerBuilder actions(List<? extends Row> actions) {
            this.actions = actions;
            return this;
        }

        public BatchCallerBuilder operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public BatchCallerBuilder rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public BatchCallerBuilder pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public BatchCallerBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public BatchCallerBuilder startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public <T> AsyncBatchRpcRetryingCaller<T> build() {
            return new AsyncBatchRpcRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.tableName, this.actions, this.pauseNs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public <T> List<CompletableFuture<T>> call() {
            return this.build().call();
        }
    }

    public class ScanSingleRegionCallerBuilder
    extends BuilderBase {
        private Long scannerId;
        private Scan scan;
        private ScanMetrics scanMetrics;
        private ScanResultCache resultCache;
        private RawScanResultConsumer consumer;
        private ClientProtos.ClientService.Interface stub;
        private HRegionLocation loc;
        private boolean isRegionServerRemote;
        private long scannerLeaseTimeoutPeriodNs;
        private long scanTimeoutNs;
        private long rpcTimeoutNs;

        public ScanSingleRegionCallerBuilder() {
            this.scannerId = null;
        }

        public ScanSingleRegionCallerBuilder id(long scannerId) {
            this.scannerId = scannerId;
            return this;
        }

        public ScanSingleRegionCallerBuilder setScan(Scan scan) {
            this.scan = scan;
            return this;
        }

        public ScanSingleRegionCallerBuilder metrics(ScanMetrics scanMetrics) {
            this.scanMetrics = scanMetrics;
            return this;
        }

        public ScanSingleRegionCallerBuilder remote(boolean isRegionServerRemote) {
            this.isRegionServerRemote = isRegionServerRemote;
            return this;
        }

        public ScanSingleRegionCallerBuilder resultCache(ScanResultCache resultCache) {
            this.resultCache = resultCache;
            return this;
        }

        public ScanSingleRegionCallerBuilder consumer(RawScanResultConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public ScanSingleRegionCallerBuilder stub(ClientProtos.ClientService.Interface stub) {
            this.stub = stub;
            return this;
        }

        public ScanSingleRegionCallerBuilder location(HRegionLocation loc) {
            this.loc = loc;
            return this;
        }

        public ScanSingleRegionCallerBuilder scannerLeaseTimeoutPeriod(long scannerLeaseTimeoutPeriod, TimeUnit unit) {
            this.scannerLeaseTimeoutPeriodNs = unit.toNanos(scannerLeaseTimeoutPeriod);
            return this;
        }

        public ScanSingleRegionCallerBuilder scanTimeout(long scanTimeout, TimeUnit unit) {
            this.scanTimeoutNs = unit.toNanos(scanTimeout);
            return this;
        }

        public ScanSingleRegionCallerBuilder rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public ScanSingleRegionCallerBuilder pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public ScanSingleRegionCallerBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public ScanSingleRegionCallerBuilder startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public AsyncScanSingleRegionRpcRetryingCaller build() {
            Preconditions.checkArgument((this.scannerId != null ? 1 : 0) != 0, (String)"invalid scannerId %d", (Object)this.scannerId);
            return new AsyncScanSingleRegionRpcRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, (Scan)Preconditions.checkNotNull((Object)this.scan, (Object)"scan is null"), this.scanMetrics, this.scannerId, (ScanResultCache)Preconditions.checkNotNull((Object)this.resultCache, (Object)"resultCache is null"), (RawScanResultConsumer)Preconditions.checkNotNull((Object)this.consumer, (Object)"consumer is null"), (ClientProtos.ClientService.Interface)Preconditions.checkNotNull((Object)this.stub, (Object)"stub is null"), (HRegionLocation)Preconditions.checkNotNull((Object)this.loc, (Object)"location is null"), this.isRegionServerRemote, this.scannerLeaseTimeoutPeriodNs, this.pauseNs, this.maxAttempts, this.scanTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public CompletableFuture<Boolean> start(HBaseRpcController controller, ClientProtos.ScanResponse respWhenOpen) {
            return this.build().start(controller, respWhenOpen);
        }
    }

    public class SingleRequestCallerBuilder<T>
    extends BuilderBase {
        private TableName tableName;
        private byte[] row;
        private AsyncSingleRequestRpcRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;
        private RegionLocateType locateType;

        public SingleRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
            this.locateType = RegionLocateType.CURRENT;
        }

        public SingleRequestCallerBuilder<T> table(TableName tableName) {
            this.tableName = tableName;
            return this;
        }

        public SingleRequestCallerBuilder<T> row(byte[] row) {
            this.row = row;
            return this;
        }

        public SingleRequestCallerBuilder<T> action(AsyncSingleRequestRpcRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public SingleRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public SingleRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public SingleRequestCallerBuilder<T> locateType(RegionLocateType locateType) {
            this.locateType = locateType;
            return this;
        }

        public SingleRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public SingleRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public SingleRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public AsyncSingleRequestRpcRetryingCaller<T> build() {
            return new AsyncSingleRequestRpcRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, (TableName)Preconditions.checkNotNull((Object)this.tableName, (Object)"tableName is null"), (byte[])Preconditions.checkNotNull((Object)this.row, (Object)"row is null"), (RegionLocateType)((Object)Preconditions.checkNotNull((Object)((Object)this.locateType), (Object)"locateType is null")), (AsyncSingleRequestRpcRetryingCaller.Callable)Preconditions.checkNotNull(this.callable, (Object)"action is null"), this.pauseNs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    private abstract class BuilderBase {
        protected long pauseNs;
        protected int maxAttempts;
        protected int startLogErrorsCnt;

        private BuilderBase() {
            this.pauseNs = ((AsyncRpcRetryingCallerFactory)AsyncRpcRetryingCallerFactory.this).conn.connConf.getPauseNs();
            this.maxAttempts = ConnectionUtils.retries2Attempts(((AsyncRpcRetryingCallerFactory)AsyncRpcRetryingCallerFactory.this).conn.connConf.getMaxRetries());
            this.startLogErrorsCnt = ((AsyncRpcRetryingCallerFactory)AsyncRpcRetryingCallerFactory.this).conn.connConf.getStartLogErrorsCnt();
        }
    }
}

