/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.apache.hama.bsp.BSPPeer;
import org.apache.hama.graph.GraphJobMessage;

public final class VertexMessageIterable<V, T>
implements Iterable<T> {
    private final V vertexID;
    private final BSPPeer<Writable, Writable, Writable, Writable, GraphJobMessage> peer;
    private GraphJobMessage overflow;
    private GraphJobMessage currentMessage;
    private Iterator<T> currentIterator;

    public VertexMessageIterable(GraphJobMessage currentMessage, V vertexID, BSPPeer<Writable, Writable, Writable, Writable, GraphJobMessage> peer) {
        this.currentMessage = currentMessage;
        this.vertexID = vertexID;
        this.peer = peer;
        this.setupIterator();
    }

    private void setupIterator() {
        this.currentIterator = new AbstractIterator<T>(){

            protected T computeNext() {
                if (VertexMessageIterable.this.currentMessage != null) {
                    GraphJobMessage tmp = VertexMessageIterable.this.currentMessage;
                    VertexMessageIterable.this.currentMessage = null;
                    return tmp.getVertexValue();
                }
                try {
                    GraphJobMessage msg = (GraphJobMessage)VertexMessageIterable.this.peer.getCurrentMessage();
                    if (msg != null) {
                        if (msg.getVertexId().equals(VertexMessageIterable.this.vertexID)) {
                            return msg.getVertexValue();
                        }
                        VertexMessageIterable.this.overflow = msg;
                    }
                    return this.endOfData();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public GraphJobMessage getOverflowMessage() {
        while (this.currentIterator.hasNext()) {
            this.currentIterator.next();
        }
        return this.overflow;
    }

    @Override
    public Iterator<T> iterator() {
        return this.currentIterator;
    }
}

