/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.bsp.BSPPeer;
import org.apache.hama.bsp.Partitioner;
import org.apache.hama.bsp.PartitioningRunner;
import org.apache.hama.commons.util.KeyValuePair;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.Vertex;

public abstract class VertexInputReader<KEYIN extends Writable, VALUEIN extends Writable, V extends WritableComparable, E extends Writable, M extends Writable>
implements PartitioningRunner.RecordConverter {
    private final KeyValuePair<Writable, Writable> outputRecord = new KeyValuePair();

    public void setup(Configuration conf) {
        GraphJobRunner.initClasses(conf);
    }

    public abstract boolean parseVertex(KEYIN var1, VALUEIN var2, Vertex<V, E, M> var3) throws Exception;

    public KeyValuePair<Writable, Writable> convertRecord(KeyValuePair<Writable, Writable> inputRecord, Configuration conf) throws IOException {
        boolean vertexCreation;
        Class vertexClass = conf.getClass("hama.graph.vertex.class", Vertex.class);
        Vertex vertex = GraphJobRunner.newVertexInstance(vertexClass);
        try {
            vertexCreation = this.parseVertex((Writable)inputRecord.getKey(), (Writable)inputRecord.getValue(), vertex);
        }
        catch (Exception e) {
            vertexCreation = false;
        }
        if (!vertexCreation) {
            throw new IOException("Error parsing vertex. Please check your vertex input reader.");
        }
        this.outputRecord.setKey(vertex.getVertexID());
        this.outputRecord.setValue(vertex);
        return this.outputRecord;
    }

    public int getPartitionId(KeyValuePair<Writable, Writable> inputRecord, Partitioner partitioner, Configuration conf, BSPPeer peer, int numTasks) {
        Vertex vertex = (Vertex)this.outputRecord.getValue();
        return Math.abs(partitioner.getPartition(vertex.getVertexID(), vertex.getValue(), numTasks));
    }
}

