/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.bsp.TaskAttemptID;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.IDSkippingIterator;
import org.apache.hama.graph.Vertex;
import org.apache.hama.graph.VerticesInfo;

public final class ListVerticesInfo<V extends WritableComparable<V>, E extends Writable, M extends Writable>
implements VerticesInfo<V, E, M> {
    private final SortedSet<Vertex<V, E, M>> vertices = new TreeSet<Vertex<V, E, M>>();
    private final Vertex<V, E, M> vertexTemplate = GraphJobRunner.newVertexInstance(GraphJobRunner.VERTEX_CLASS);

    @Override
    public void addVertex(Vertex<V, E, M> vertex) {
        if (!this.vertices.add(vertex)) {
            throw new UnsupportedOperationException("Vertex with ID: " + vertex.getVertexID() + " already exists!");
        }
    }

    @Override
    public void removeVertex(V vertexID) throws UnsupportedOperationException {
        this.vertexTemplate.setVertexID(vertexID);
        if (!this.vertices.remove(this.vertexTemplate)) {
            throw new UnsupportedOperationException("Vertex with ID: " + vertexID + " not found on this peer.");
        }
    }

    public void clear() {
        this.vertices.clear();
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public IDSkippingIterator<V, E, M> skippingIterator() {
        return new IDSkippingIterator<V, E, M>(){
            Iterator<Vertex<V, E, M>> it;
            Vertex<V, E, M> v;
            {
                this.it = ListVerticesInfo.this.vertices.iterator();
            }

            @Override
            public boolean hasNext(V msgId, IDSkippingIterator.Strategy strat) {
                if (this.it.hasNext()) {
                    this.v = this.it.next();
                    while (!strat.accept(this.v, (WritableComparable)msgId)) {
                        if (this.it.hasNext()) {
                            this.v = this.it.next();
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                this.v = null;
                return false;
            }

            @Override
            public Vertex<V, E, M> next() {
                if (this.v == null) {
                    throw new UnsupportedOperationException("You must invoke hasNext before ask for the next vertex.");
                }
                Vertex tmp = this.v;
                this.v = null;
                return tmp;
            }
        };
    }

    @Override
    public void finishVertexComputation(Vertex<V, E, M> vertex) {
    }

    @Override
    public void finishAdditions() {
    }

    @Override
    public void finishRemovals() {
    }

    @Override
    public void finishSuperstep() {
    }

    @Override
    public void cleanup(Configuration conf, TaskAttemptID attempt) throws IOException {
    }

    @Override
    public void startSuperstep() throws IOException {
    }

    @Override
    public void init(GraphJobRunner<V, E, M> runner, Configuration conf, TaskAttemptID attempt) throws IOException {
    }
}

