/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hama.graph.GraphJobRunner;

public final class GraphJobMessage
implements WritableComparable<GraphJobMessage> {
    public static final int MAP_FLAG = 1;
    public static final int VERTEX_FLAG = 2;
    public static final int VERTICES_SIZE_FLAG = 4;
    private int flag = -1;
    private MapWritable map;
    private WritableComparable vertexId;
    private Writable vertexValue;
    private IntWritable verticesSize;
    private static GraphJobMessageComparator comparator;

    public GraphJobMessage() {
    }

    public GraphJobMessage(MapWritable map) {
        this.flag = 1;
        this.map = map;
    }

    public GraphJobMessage(WritableComparable<?> vertexId, Writable vertexValue) {
        this.flag = 2;
        this.vertexId = vertexId;
        this.vertexValue = vertexValue;
    }

    public GraphJobMessage(IntWritable size) {
        this.flag = 4;
        this.verticesSize = size;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.flag);
        if (this.isVertexMessage()) {
            this.vertexId.write(out);
            this.vertexValue.write(out);
        } else if (this.isMapMessage()) {
            this.map.write(out);
        } else if (this.isVerticesSizeMessage()) {
            this.verticesSize.write(out);
        } else {
            this.vertexId.write(out);
        }
    }

    public void fastReadFields(DataInput in) throws IOException {
        this.flag = in.readByte();
        if (this.isVertexMessage()) {
            this.vertexId = (WritableComparable)GraphJobRunner.createVertexIDObject();
            this.vertexId.readFields(in);
        } else if (this.isMapMessage()) {
            this.map = new MapWritable();
            this.map.readFields(in);
        } else if (this.isVerticesSizeMessage()) {
            this.verticesSize = new IntWritable();
            this.verticesSize.readFields(in);
        } else {
            this.vertexId = (WritableComparable)ReflectionUtils.newInstance(GraphJobRunner.VERTEX_ID_CLASS, null);
            this.vertexId.readFields(in);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.flag = in.readByte();
        if (this.isVertexMessage()) {
            this.vertexId = (WritableComparable)GraphJobRunner.createVertexIDObject();
            this.vertexId.readFields(in);
            this.vertexValue = GraphJobRunner.createVertexValue();
            this.vertexValue.readFields(in);
        } else if (this.isMapMessage()) {
            this.map = new MapWritable();
            this.map.readFields(in);
        } else if (this.isVerticesSizeMessage()) {
            this.verticesSize = new IntWritable();
            this.verticesSize.readFields(in);
        } else {
            this.vertexId = (WritableComparable)ReflectionUtils.newInstance(GraphJobRunner.VERTEX_ID_CLASS, null);
            this.vertexId.readFields(in);
        }
    }

    public int compareTo(GraphJobMessage that) {
        if (this.flag != that.flag) {
            return this.flag - that.flag;
        }
        if (this.isVertexMessage()) {
            return this.vertexId.compareTo((Object)that.vertexId);
        }
        if (this.isMapMessage()) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    public MapWritable getMap() {
        return this.map;
    }

    public Writable getVertexId() {
        return this.vertexId;
    }

    public Writable getVertexValue() {
        return this.vertexValue;
    }

    public IntWritable getVerticesSize() {
        return this.verticesSize;
    }

    public boolean isMapMessage() {
        return this.flag == 1;
    }

    public boolean isVertexMessage() {
        return this.flag == 2;
    }

    public boolean isVerticesSizeMessage() {
        return this.flag == 4;
    }

    public String toString() {
        if (this.isVertexMessage()) {
            return "ID: " + this.vertexId + " Val: " + this.vertexValue;
        }
        if (this.isMapMessage()) {
            return "Map: " + this.map;
        }
        if (this.isVerticesSizeMessage()) {
            return "#Vertices: " + this.verticesSize;
        }
        return "GraphJobMessage [flag=" + this.flag + ", map=" + this.map + ", vertexId=" + this.vertexId + ", vertexValue=" + this.vertexValue + "]";
    }

    static {
        if (comparator == null) {
            comparator = new GraphJobMessageComparator();
        }
        WritableComparator.define(GraphJobMessage.class, (WritableComparator)comparator);
    }

    public static class GraphJobMessageComparator
    extends WritableComparator {
        private final DataInputBuffer buffer;
        private final GraphJobMessage key1 = new GraphJobMessage();
        private final GraphJobMessage key2 = new GraphJobMessage();

        public GraphJobMessageComparator() {
            this(GraphJobMessage.class);
        }

        protected GraphJobMessageComparator(Class<? extends WritableComparable<?>> keyClass) {
            this(keyClass, false);
        }

        protected GraphJobMessageComparator(Class<? extends WritableComparable<?>> keyClass, boolean createInstances) {
            super(keyClass, createInstances);
            this.buffer = new DataInputBuffer();
        }

        public synchronized int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                this.buffer.reset(b1, s1, l1);
                this.key1.fastReadFields((DataInput)this.buffer);
                this.buffer.reset(b2, s2, l2);
                this.key2.fastReadFields((DataInput)this.buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.compare(this.key1, this.key2);
        }
    }
}

