/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.bsp.TaskAttemptID;
import org.apache.hama.graph.Edge;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.IDSkippingIterator;
import org.apache.hama.graph.Vertex;
import org.apache.hama.graph.VerticesInfo;

public final class DiskVerticesInfo<V extends WritableComparable, E extends Writable, M extends Writable>
implements VerticesInfo<V, E, M> {
    public static final String DISK_VERTICES_PATH_KEY = "hama.disk.vertices.path";
    private static final byte NULL = 0;
    private static final byte NOT_NULL = 1;
    private FSDataOutputStream staticGraphPartsDos;
    private FSDataInputStream staticGraphPartsDis;
    private FSDataOutputStream softGraphPartsDos;
    private FSDataInputStream softGraphPartsDis;
    private FSDataOutputStream softGraphPartsNextIterationDos;
    private BitSet activeVertices;
    private long[] softValueOffsets;
    private long[] softValueOffsetsNextIteration;
    private long[] staticOffsets;
    private ArrayList<Long> tmpSoftOffsets;
    private ArrayList<Long> tmpStaticOffsets;
    private int size;
    private boolean lockedAdditions = false;
    private String rootPath;
    private Vertex<V, E, M> cachedVertexInstance;
    private int currentStep = 0;
    private int index = 0;
    private Configuration conf;
    private GraphJobRunner<V, E, M> runner;
    private String staticFile;

    @Override
    public void init(GraphJobRunner<V, E, M> runner, Configuration conf, TaskAttemptID attempt) throws IOException {
        this.runner = runner;
        this.conf = conf;
        this.tmpSoftOffsets = new ArrayList();
        this.tmpStaticOffsets = new ArrayList();
        String p = conf.get(DISK_VERTICES_PATH_KEY, "/tmp/graph/");
        this.rootPath = p + attempt.getJobID().toString() + "/" + attempt.toString() + "/";
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        local.mkdirs(new Path(this.rootPath));
        this.staticFile = this.rootPath + "static.graph";
        local.delete(new Path(this.staticFile), false);
        this.staticGraphPartsDos = local.create(new Path(this.staticFile));
        String softGraphFileName = DiskVerticesInfo.getSoftGraphFileName(this.rootPath, this.currentStep);
        local.delete(new Path(softGraphFileName), false);
        this.softGraphPartsDos = local.create(new Path(softGraphFileName));
    }

    @Override
    public void cleanup(Configuration conf, TaskAttemptID attempt) throws IOException {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.softGraphPartsDos, this.softGraphPartsNextIterationDos, this.staticGraphPartsDis, this.softGraphPartsDis});
        FileSystem.getLocal((Configuration)conf).delete(new Path(this.rootPath), true);
    }

    @Override
    public void addVertex(Vertex<V, E, M> vertex) throws IOException {
        Preconditions.checkArgument((!this.lockedAdditions ? 1 : 0) != 0, (Object)"Additions are locked now, nobody is allowed to change the structure anymore.");
        this.tmpStaticOffsets.add(this.staticGraphPartsDos.getPos());
        vertex.getVertexID().write((DataOutput)this.staticGraphPartsDos);
        this.staticGraphPartsDos.writeInt(vertex.getEdges() == null ? 0 : vertex.getEdges().size());
        for (Edge<V, E> e : vertex.getEdges()) {
            e.getDestinationVertexID().write((DataOutput)this.staticGraphPartsDos);
        }
        this.serializeSoft(vertex, -1, null, this.softGraphPartsDos);
        ++this.size;
    }

    @Override
    public void removeVertex(V vertexID) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void serializeSoft(Vertex<V, E, M> vertex, int index, long[] softValueOffsets, FSDataOutputStream softGraphParts) throws IOException {
        if (index >= 0) {
            softValueOffsets[index] = softGraphParts.getPos();
            this.activeVertices.set(index, vertex.isHalted());
        } else {
            this.tmpSoftOffsets.add(softGraphParts.getPos());
        }
        if (vertex.getValue() == null) {
            softGraphParts.write(0);
        } else {
            softGraphParts.write(1);
            vertex.getValue().write((DataOutput)softGraphParts);
        }
        vertex.writeState((DataOutput)softGraphParts);
        softGraphParts.writeInt(vertex.getEdges().size());
        for (Edge<V, E> e : vertex.getEdges()) {
            if (e.getValue() == null) {
                softGraphParts.write(0);
                continue;
            }
            softGraphParts.write(1);
            e.getValue().write((DataOutput)softGraphParts);
        }
    }

    @Override
    public void finishAdditions() {
        this.softValueOffsets = DiskVerticesInfo.copy(this.tmpSoftOffsets);
        this.softValueOffsetsNextIteration = DiskVerticesInfo.copy(this.tmpSoftOffsets);
        this.staticOffsets = DiskVerticesInfo.copy(this.tmpStaticOffsets);
        this.activeVertices = new BitSet(this.size);
        this.tmpStaticOffsets = null;
        this.tmpSoftOffsets = null;
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.staticGraphPartsDos, this.softGraphPartsDos});
        this.lockedAdditions = true;
    }

    @Override
    public void finishRemovals() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static long[] copy(ArrayList<Long> lst) {
        long[] arr = new long[lst.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = lst.get(i);
        }
        return arr;
    }

    @Override
    public void startSuperstep() throws IOException {
        this.index = 0;
        String softGraphFileName = DiskVerticesInfo.getSoftGraphFileName(this.rootPath, this.currentStep);
        LocalFileSystem local = FileSystem.getLocal((Configuration)this.conf);
        local.delete(new Path(softGraphFileName), true);
        this.softGraphPartsNextIterationDos = local.create(new Path(softGraphFileName));
        this.softValueOffsets = this.softValueOffsetsNextIteration;
        this.softValueOffsetsNextIteration = new long[this.softValueOffsetsNextIteration.length];
    }

    @Override
    public void finishVertexComputation(Vertex<V, E, M> vertex) throws IOException {
        this.serializeSoft(vertex, this.index++, this.softValueOffsetsNextIteration, this.softGraphPartsNextIterationDos);
    }

    @Override
    public void finishSuperstep() throws IOException {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.softGraphPartsDos, this.softGraphPartsNextIterationDos, this.softGraphPartsDis});
        if (this.currentStep > 0) {
            LocalFileSystem local = FileSystem.getLocal((Configuration)this.conf);
            local.delete(new Path(DiskVerticesInfo.getSoftGraphFileName(this.rootPath, this.currentStep - 1)), true);
            String softGraphFileName = DiskVerticesInfo.getSoftGraphFileName(this.rootPath, this.currentStep);
            this.softGraphPartsDis = local.open(new Path(softGraphFileName));
        }
        ++this.currentStep;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IDSkippingIterator<V, E, M> skippingIterator() {
        try {
            String softGraphFileName = DiskVerticesInfo.getSoftGraphFileName(this.rootPath, Math.max(0, this.currentStep - 1));
            LocalFileSystem local = FileSystem.getLocal((Configuration)this.conf);
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.softGraphPartsDos, this.softGraphPartsDis, this.staticGraphPartsDis, this.staticGraphPartsDos});
            this.softGraphPartsDis = local.open(new Path(softGraphFileName));
            this.staticGraphPartsDis = local.open(new Path(this.staticFile));
            if (this.cachedVertexInstance == null) {
                this.cachedVertexInstance = GraphJobRunner.newVertexInstance(GraphJobRunner.VERTEX_CLASS);
                this.cachedVertexInstance.setRunner(this.runner);
            }
            this.ensureVertexIDNotNull();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new IDSkippingDiskIterator();
    }

    private void ensureVertexIDNotNull() {
        if (this.cachedVertexInstance.getVertexID() == null) {
            this.cachedVertexInstance.setVertexID((WritableComparable)GraphJobRunner.createVertexIDObject());
        }
    }

    private void ensureVertexValueNotNull() {
        if (this.cachedVertexInstance.getValue() == null) {
            this.cachedVertexInstance.setValue(GraphJobRunner.createVertexValue());
        }
    }

    private void ensureEdgeIDNotNull(Edge<V, E> edge) {
        if (edge.getDestinationVertexID() == null) {
            edge.setDestinationVertexID((WritableComparable)GraphJobRunner.createVertexIDObject());
        }
    }

    private void ensureEdgeValueNotNull(Edge<V, E> edge) {
        if (edge.getValue() == null) {
            edge.setCost(GraphJobRunner.createEdgeCostObject());
        }
    }

    private int fill(IDSkippingIterator.Strategy strat, int index, V messageVertexId) {
        try {
            block8: {
                do {
                    this.staticGraphPartsDis.seek(this.staticOffsets[index]);
                    boolean halted = this.activeVertices.get(index);
                    this.cachedVertexInstance.setVotedToHalt(halted);
                    this.cachedVertexInstance.getVertexID().readFields((DataInput)this.staticGraphPartsDis);
                    if (strat.accept(this.cachedVertexInstance, (WritableComparable)messageVertexId)) break block8;
                } while (++index < this.size);
                return this.size;
            }
            this.softGraphPartsDis.seek(this.softValueOffsets[index]);
            this.cachedVertexInstance.setValue(null);
            if (this.softGraphPartsDis.readByte() == 1) {
                this.ensureVertexValueNotNull();
                this.cachedVertexInstance.getValue().readFields((DataInput)this.softGraphPartsDis);
            }
            this.cachedVertexInstance.readState((DataInput)this.softGraphPartsDis);
            int numEdges = this.staticGraphPartsDis.readInt();
            int softEdges = this.softGraphPartsDis.readInt();
            if (softEdges != numEdges) {
                throw new IllegalArgumentException("Number of edges seemed to change. This is not possible (yet).");
            }
            ArrayList edges = new ArrayList();
            for (int i = 0; i < numEdges; ++i) {
                Edge edge = new Edge();
                this.ensureEdgeValueNotNull(edge);
                this.ensureEdgeIDNotNull(edge);
                edge.getDestinationVertexID().readFields((DataInput)this.staticGraphPartsDis);
                if (this.softGraphPartsDis.readByte() == 1) {
                    this.ensureEdgeValueNotNull(edge);
                    edge.getCost().readFields((DataInput)this.softGraphPartsDis);
                } else {
                    edge.setCost(null);
                }
                edges.add(edge);
            }
            this.cachedVertexInstance.setEdges(Collections.unmodifiableList(edges));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return index + 1;
    }

    private static String getSoftGraphFileName(String root, int step) {
        return root + "soft_" + step + ".graph";
    }

    private final class IDSkippingDiskIterator
    extends IDSkippingIterator<V, E, M> {
        int currentIndex = 0;

        private IDSkippingDiskIterator() {
        }

        @Override
        public Vertex<V, E, M> next() {
            return DiskVerticesInfo.this.cachedVertexInstance;
        }

        @Override
        public boolean hasNext(V e, IDSkippingIterator.Strategy strat) {
            if (this.currentIndex >= DiskVerticesInfo.this.size) {
                return false;
            }
            this.currentIndex = DiskVerticesInfo.this.fill(strat, this.currentIndex, e);
            return true;
        }
    }
}

