/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.graph.Vertex;

public abstract class IDSkippingIterator<V extends WritableComparable, E extends Writable, M extends Writable> {
    public boolean hasNext() {
        return this.hasNext(null, Strategy.ALL);
    }

    public abstract boolean hasNext(V var1, Strategy var2);

    public abstract Vertex<V, E, M> next();

    static enum Strategy {
        ALL,
        ACTIVE,
        ACTIVE_AND_MESSAGES,
        INACTIVE;


        public boolean accept(Vertex v, WritableComparable msgId) {
            switch (this) {
                case ACTIVE_AND_MESSAGES: {
                    if (msgId != null) {
                        return !v.isHalted() || v.getVertexID().compareTo((Object)msgId) == 0;
                    }
                }
                case ACTIVE: {
                    return !v.isHalted();
                }
                case INACTIVE: {
                    return v.isHalted();
                }
            }
            return true;
        }
    }
}

