/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.bsp.BSPPeer;
import org.apache.hama.bsp.Partitioner;
import org.apache.hama.bsp.PartitioningRunner;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.Vertex;
import org.apache.hama.util.KeyValuePair;

public abstract class VertexInputReader<KEYIN extends Writable, VALUEIN extends Writable, V extends WritableComparable, E extends Writable, M extends Writable>
implements PartitioningRunner.RecordConverter {
    private static final Log LOG = LogFactory.getLog(VertexInputReader.class);
    private final KeyValuePair<Writable, Writable> outputRecord = new KeyValuePair();

    public void setup(Configuration conf) {
        GraphJobRunner.initClasses(conf);
    }

    public abstract boolean parseVertex(KEYIN var1, VALUEIN var2, Vertex<V, E, M> var3) throws Exception;

    public KeyValuePair<Writable, Writable> convertRecord(KeyValuePair<Writable, Writable> inputRecord, Configuration conf) {
        boolean vertexCreation;
        Class vertexClass = conf.getClass("hama.graph.vertex.class", Vertex.class);
        Vertex vertex = GraphJobRunner.newVertexInstance(vertexClass);
        try {
            vertexCreation = this.parseVertex((Writable)inputRecord.getKey(), (Writable)inputRecord.getValue(), vertex);
        }
        catch (Exception e) {
            LOG.error((Object)"Error parsing vertex.", (Throwable)e);
            vertexCreation = false;
        }
        if (!vertexCreation) {
            return null;
        }
        this.outputRecord.setKey(vertex);
        this.outputRecord.setValue((Object)NullWritable.get());
        return this.outputRecord;
    }

    public int getPartitionId(KeyValuePair<Writable, Writable> inputRecord, Partitioner partitioner, Configuration conf, BSPPeer peer, int numTasks) {
        Vertex vertex = (Vertex)this.outputRecord.getKey();
        return Math.abs(partitioner.getPartition(vertex.getVertexID(), vertex.getValue(), numTasks));
    }

    public final Map<Writable, Writable> newMap() {
        return new TreeMap<Writable, Writable>();
    }
}

