/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.bsp.TaskAttemptID;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.IDSkippingIterator;
import org.apache.hama.graph.Vertex;
import org.apache.hama.graph.VerticesInfo;

public final class ListVerticesInfo<V extends WritableComparable<V>, E extends Writable, M extends Writable>
implements VerticesInfo<V, E, M> {
    private final List<Vertex<V, E, M>> vertices = new ArrayList<Vertex<V, E, M>>(100);

    @Override
    public void addVertex(Vertex<V, E, M> vertex) {
        this.vertices.add(vertex);
    }

    public void clear() {
        this.vertices.clear();
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public IDSkippingIterator<V, E, M> skippingIterator() {
        return new IDSkippingIterator<V, E, M>(){
            int currentIndex = 0;

            @Override
            public boolean hasNext(V e, IDSkippingIterator.Strategy strat) {
                if (this.currentIndex < ListVerticesInfo.this.vertices.size()) {
                    while (!strat.accept((Vertex)ListVerticesInfo.this.vertices.get(this.currentIndex), (WritableComparable)e)) {
                        ++this.currentIndex;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public Vertex<V, E, M> next() {
                return (Vertex)ListVerticesInfo.this.vertices.get(this.currentIndex++);
            }
        };
    }

    @Override
    public void finishVertexComputation(Vertex<V, E, M> vertex) {
    }

    @Override
    public void finishAdditions() {
        Collections.sort(this.vertices);
    }

    @Override
    public boolean isFinishedAdditions() {
        return false;
    }

    @Override
    public void finishSuperstep() {
    }

    @Override
    public void cleanup(Configuration conf, TaskAttemptID attempt) throws IOException {
    }

    @Override
    public void startSuperstep() throws IOException {
    }

    @Override
    public void init(GraphJobRunner<V, E, M> runner, Configuration conf, TaskAttemptID attempt) throws IOException {
    }
}

