/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hama.HamaConfiguration;
import org.apache.hama.bsp.BSPJob;
import org.apache.hama.bsp.Combiner;
import org.apache.hama.bsp.HashPartitioner;
import org.apache.hama.bsp.Partitioner;
import org.apache.hama.graph.Aggregator;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.Vertex;
import org.apache.hama.graph.VertexInputReader;

public class GraphJob
extends BSPJob {
    public static final String VERTEX_CLASS_ATTR = "hama.graph.vertex.class";
    public static final String VERTEX_ID_CLASS_ATTR = "hama.graph.vertex.id.class";
    public static final String VERTEX_VALUE_CLASS_ATTR = "hama.graph.vertex.value.class";
    public static final String VERTEX_EDGE_VALUE_CLASS_ATTR = "hama.graph.vertex.edge.value.class";
    public static final String AGGREGATOR_CLASS_ATTR = "hama.graph.aggregator.class";
    public static final String VERTEX_MESSAGE_COMBINER_CLASS_ATTR = "hama.vertex.message.combiner.class";
    public static final String VERTEX_GRAPH_RUNTIME_PARTIONING = "hama.graph.runtime.partitioning";
    public static final String VERTEX_GRAPH_INPUT_READER = "hama.graph.input.reader.class";

    public GraphJob(HamaConfiguration conf, Class<?> exampleClass) throws IOException {
        super(conf);
        this.setBspClass(GraphJobRunner.class);
        this.setJarByClass(exampleClass);
        this.setVertexIDClass(Text.class);
        this.setVertexValueClass(IntWritable.class);
        this.setEdgeValueClass(IntWritable.class);
        this.setPartitioner(HashPartitioner.class);
    }

    public void setVertexClass(Class<? extends Vertex<? extends Writable, ? extends Writable, ? extends Writable>> cls) throws IllegalStateException {
        this.conf.setClass(VERTEX_CLASS_ATTR, cls, Vertex.class);
    }

    public void setVertexIDClass(Class<? extends Writable> cls) throws IllegalStateException {
        this.conf.setClass(VERTEX_ID_CLASS_ATTR, cls, Writable.class);
    }

    public void setVertexValueClass(Class<? extends Writable> cls) throws IllegalStateException {
        this.conf.setClass(VERTEX_VALUE_CLASS_ATTR, cls, Writable.class);
    }

    public void setEdgeValueClass(Class<? extends Writable> cls) throws IllegalStateException {
        this.conf.setClass(VERTEX_EDGE_VALUE_CLASS_ATTR, cls, Writable.class);
    }

    public void setAggregatorClass(Class<? extends Aggregator> cls) {
        this.setAggregatorClass(new Class[]{cls});
    }

    public void setAggregatorClass(Class<? extends Aggregator> ... cls) {
        String classNames = "";
        for (Class<? extends Aggregator> cl : cls) {
            classNames = classNames + cl.getName() + ";";
        }
        this.conf.set(AGGREGATOR_CLASS_ATTR, classNames);
    }

    public void setVertexInputReaderClass(Class<? extends VertexInputReader<?, ?, ?, ?, ?>> cls) {
        this.ensureState(BSPJob.JobState.DEFINE);
        this.conf.setClass(VERTEX_GRAPH_INPUT_READER, cls, VertexInputReader.class);
    }

    public Class<? extends Vertex<? extends Writable, ? extends Writable, ? extends Writable>> getVertexClass() {
        return this.conf.getClass(VERTEX_CLASS_ATTR, Vertex.class);
    }

    public void setPartitioner(Class<? extends Partitioner> theClass) {
        super.setPartitioner(theClass);
        this.conf.setBoolean(VERTEX_GRAPH_RUNTIME_PARTIONING, true);
    }

    public void setCombinerClass(Class<? extends Combiner<? extends Writable>> cls) {
        this.ensureState(BSPJob.JobState.DEFINE);
        this.conf.setClass(VERTEX_MESSAGE_COMBINER_CLASS_ATTR, cls, Combiner.class);
    }

    public void setMaxIteration(int maxIteration) {
        this.conf.setInt("hama.graph.max.iteration", maxIteration);
    }

    public void submit() throws IOException, InterruptedException {
        Preconditions.checkArgument((this.getConf().get(VERTEX_CLASS_ATTR) != null ? 1 : 0) != 0, (Object)"Please provide a vertex class!");
        Preconditions.checkArgument((this.getConf().get(VERTEX_ID_CLASS_ATTR) != null ? 1 : 0) != 0, (Object)"Please provide an vertex ID class!");
        Preconditions.checkArgument((this.getConf().get(VERTEX_VALUE_CLASS_ATTR) != null ? 1 : 0) != 0, (Object)"Please provide an vertex value class, if you don't need one, use NullWritable!");
        Preconditions.checkArgument((this.getConf().get(VERTEX_EDGE_VALUE_CLASS_ATTR) != null ? 1 : 0) != 0, (Object)"Please provide an edge value class, if you don't need one, use NullWritable!");
        Preconditions.checkArgument((this.getConf().get(VERTEX_GRAPH_INPUT_READER) != null ? 1 : 0) != 0, (Object)"Please provide a vertex input reader!");
        super.submit();
    }
}

