/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOverrideTimelineStoreYarnClient {
    @Test
    void testLifecycleAndOverride() throws Throwable {
        YarnConfiguration conf = new YarnConfiguration();
        try (NoRMStore store = new NoRMStore();){
            store.init((Configuration)conf);
            store.start();
            Assertions.assertEquals((Object)EntityGroupFSTimelineStore.AppState.ACTIVE, (Object)store.getAppState(ApplicationId.newInstance((long)1L, (int)1)));
            store.stop();
        }
    }

    private static class NoRMStore
    extends EntityGroupFSTimelineStore {
        private NoRMStore() {
        }

        protected YarnClient createAndInitYarnClient(Configuration conf) {
            return null;
        }

        protected EntityGroupFSTimelineStore.AppState getAppState(ApplicationId appId) throws IOException {
            return EntityGroupFSTimelineStore.AppState.ACTIVE;
        }
    }
}

