/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTestTokenProtos;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;

public class ContainerTokenIdentifierForTest
extends ContainerTokenIdentifier {
    private static Log LOG = LogFactory.getLog(ContainerTokenIdentifier.class);
    public static final Text KIND = new Text("ContainerToken");
    private YarnSecurityTestTokenProtos.ContainerTokenIdentifierForTestProto proto;

    public ContainerTokenIdentifierForTest(ContainerId containerID, String hostName, String appSubmitter, Resource r, long expiryTimeStamp, int masterKeyId, long rmIdentifier, Priority priority, long creationTime, LogAggregationContext logAggregationContext) {
        YarnSecurityTestTokenProtos.ContainerTokenIdentifierForTestProto.Builder builder = YarnSecurityTestTokenProtos.ContainerTokenIdentifierForTestProto.newBuilder();
        if (containerID != null) {
            builder.setContainerId(((ContainerIdPBImpl)containerID).getProto());
        }
        builder.setNmHostAddr(hostName);
        builder.setAppSubmitter(appSubmitter);
        if (r != null) {
            builder.setResource(((ResourcePBImpl)r).getProto());
        }
        builder.setExpiryTimeStamp(expiryTimeStamp);
        builder.setMasterKeyId(masterKeyId);
        builder.setRmIdentifier(rmIdentifier);
        if (priority != null) {
            builder.setPriority(((PriorityPBImpl)priority).getProto());
        }
        builder.setCreationTime(creationTime);
        if (logAggregationContext != null) {
            builder.setLogAggregationContext(((LogAggregationContextPBImpl)logAggregationContext).getProto());
        }
        this.proto = builder.build();
    }

    public ContainerTokenIdentifierForTest(ContainerTokenIdentifier identifier, String message) {
        YarnSecurityTestTokenProtos.ContainerTokenIdentifierForTestProto.Builder builder = YarnSecurityTestTokenProtos.ContainerTokenIdentifierForTestProto.newBuilder();
        ContainerIdPBImpl containerID = (ContainerIdPBImpl)identifier.getContainerID();
        if (containerID != null) {
            builder.setContainerId(containerID.getProto());
        }
        builder.setNmHostAddr(identifier.getNmHostAddress());
        builder.setAppSubmitter(identifier.getApplicationSubmitter());
        ResourcePBImpl resource = (ResourcePBImpl)identifier.getResource();
        if (resource != null) {
            builder.setResource(resource.getProto());
        }
        builder.setExpiryTimeStamp(identifier.getExpiryTimeStamp());
        builder.setMasterKeyId(identifier.getMasterKeyId());
        builder.setRmIdentifier(identifier.getRMIdentifier());
        PriorityPBImpl priority = (PriorityPBImpl)identifier.getPriority();
        if (priority != null) {
            builder.setPriority(priority.getProto());
        }
        builder.setCreationTime(identifier.getCreationTime());
        builder.setMessage(message);
        LogAggregationContextPBImpl logAggregationContext = (LogAggregationContextPBImpl)identifier.getLogAggregationContext();
        if (logAggregationContext != null) {
            builder.setLogAggregationContext(logAggregationContext.getProto());
        }
        this.proto = builder.build();
    }

    public ContainerId getContainerID() {
        return new ContainerIdPBImpl(this.proto.getContainerId());
    }

    public String getApplicationSubmitter() {
        return this.proto.getAppSubmitter();
    }

    public String getNmHostAddress() {
        return this.proto.getNmHostAddr();
    }

    public Resource getResource() {
        return new ResourcePBImpl(this.proto.getResource());
    }

    public long getExpiryTimeStamp() {
        return this.proto.getExpiryTimeStamp();
    }

    public int getMasterKeyId() {
        return this.proto.getMasterKeyId();
    }

    public Priority getPriority() {
        return new PriorityPBImpl(this.proto.getPriority());
    }

    public long getCreationTime() {
        return this.proto.getCreationTime();
    }

    public long getRMIdentifier() {
        return this.proto.getRmIdentifier();
    }

    public void readFields(DataInput in) throws IOException {
        DataInputStream dis = (DataInputStream)in;
        byte[] buffer = IOUtils.toByteArray((InputStream)dis);
        this.proto = YarnSecurityTestTokenProtos.ContainerTokenIdentifierForTestProto.parseFrom((byte[])buffer);
    }

    public void write(DataOutput out) throws IOException {
        LOG.debug((Object)("Writing ContainerTokenIdentifierForTest to RPC layer: " + (Object)((Object)this)));
        out.write(this.proto.toByteArray());
    }

    YarnSecurityTestTokenProtos.ContainerTokenIdentifierForTestProto getNewProto() {
        return this.proto;
    }

    public int hashCode() {
        return this.proto.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getNewProto().equals((Object)((ContainerTokenIdentifierForTest)((Object)((Object)((Object)this)).getClass().cast(other))).getNewProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.proto);
    }
}

