/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestMiniYarnCluster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimelineServiceStartInMiniCluster() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        int numNodeManagers = 1;
        int numLocalDirs = 1;
        int numLogDirs = 1;
        conf.setBoolean("yarn.timeline-service.enabled", false);
        boolean enableAHS = false;
        MiniYARNCluster cluster = null;
        try {
            cluster = new MiniYARNCluster(TestMiniYarnCluster.class.getSimpleName(), numNodeManagers, numLocalDirs, numLogDirs, numLogDirs, enableAHS);
            cluster.init((Configuration)conf);
            cluster.start();
            Assert.assertNull((String)"Timeline Service should not have been started", (Object)cluster.getApplicationHistoryServer());
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
        conf.setBoolean("yarn.timeline-service.enabled", true);
        enableAHS = false;
        cluster = null;
        try {
            cluster = new MiniYARNCluster(TestMiniYarnCluster.class.getSimpleName(), numNodeManagers, numLocalDirs, numLogDirs, numLogDirs, enableAHS);
            cluster.init((Configuration)conf);
            String hostname = MiniYARNCluster.getHostname();
            Assert.assertEquals((Object)(hostname + ":0"), (Object)conf.get("yarn.timeline-service.address"));
            Assert.assertEquals((Object)(hostname + ":0"), (Object)conf.get("yarn.timeline-service.webapp.address"));
            cluster.start();
            for (int wait = 0; cluster.getApplicationHistoryServer() == null && wait < 20; ++wait) {
                Thread.sleep(500L);
            }
            Assert.assertNotNull((String)"Timeline Service should have been started", (Object)cluster.getApplicationHistoryServer());
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
        conf.setBoolean("yarn.timeline-service.enabled", false);
        enableAHS = true;
        cluster = null;
        try {
            cluster = new MiniYARNCluster(TestMiniYarnCluster.class.getSimpleName(), numNodeManagers, numLocalDirs, numLogDirs, numLogDirs, enableAHS);
            cluster.init((Configuration)conf);
            cluster.start();
            for (int wait = 0; cluster.getApplicationHistoryServer() == null && wait < 20; ++wait) {
                Thread.sleep(500L);
            }
            Assert.assertNotNull((String)"Timeline Service should have been started", (Object)cluster.getApplicationHistoryServer());
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
    }
}

